package com.zzsn.knowbase.controller;


import com.zzsn.knowbase.entity.KbAuthorizedUser;
import com.zzsn.knowbase.service.KbAuthorizedUserService;
import com.zzsn.knowbase.vo.AddUserPermissKnowsVo;
import com.zzsn.knowbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@RestController
@RequestMapping("/api/knowledgeUser")
public class KbAuthorizedUserController {
    @Autowired
    KbAuthorizedUserService authorizedUserService;

    /**
     * 根据id查询
     * */
    @GetMapping
    public Result<?> getById(@RequestParam(name="id",required=true) String id){
        return Result.OK(authorizedUserService.getById(id));
    }

    @PostMapping("/addOne")
    public Result<?> addOne(@RequestBody KbAuthorizedUser authorizedUser){
        return authorizedUserService.addOne(authorizedUser);
    }

    /**
     * 添加授权用户，对某个知识库分类下添加一个或者多个授权用户
     * */
    @PostMapping("/add")
    public Result<?> add(@RequestBody List<KbAuthorizedUser> authorizedUser){
        return authorizedUserService.add(authorizedUser);
    }
    /**给某个用户授权分类节点下某些知识资讯*/
    @PostMapping("/addUserPermissKnows")
    public Result<?> addUserPermissKnows(@RequestBody AddUserPermissKnowsVo addUserPermissKnowsVo){
        return authorizedUserService.addUserPermitsKnows(addUserPermissKnowsVo);
    }

    /**
     * 编辑授权用户
     * */
    @PostMapping("/edit")
    public Result<?> edit(@RequestBody KbAuthorizedUser authorizedUser){
        return authorizedUserService.edit(authorizedUser);
    }

    /**
     * 删除授权用户
     * */
    @GetMapping("/del")
    public Result<?> del(
            @RequestParam(name="id",required=true) String id,
            @RequestParam(name="knowledgeProjectId",required=true) String knowledgeProjectId

                         ){
        return Result.OK(authorizedUserService.delById(id,knowledgeProjectId));
    }

    @GetMapping("/list")
    public Result<?> list(
            @RequestParam(name="roleId",required = false) String roleId,
            @RequestParam(name="username",required = false) String username,
            @RequestParam(name="name",required = false) String name,
            @RequestParam(name="orgId",required = false) String orgId,
            @RequestParam(name="orgName",required = false) String orgName,
            @RequestParam(name="knowledgeProjectId",required = false) String knowledgeProjectId,
            @RequestParam(name="category",required = false) String category,
            @RequestParam(name="pageNum",defaultValue = "1") Integer pageNum,
            @RequestParam(name="PageSize",defaultValue = "10") Integer PageSize
    ){

        return  authorizedUserService.lists(roleId,username,name,orgId,orgName,knowledgeProjectId,category,pageNum,PageSize);

    }

    /**校验用户是否可用，并查询用户信息*/
    @GetMapping("/userPermission")
    public Result<?> userPermission(HttpServletRequest httpServletRequest){
        String token = httpServletRequest.getHeader("X-Access-Token");
        return authorizedUserService.userPermission(token);
    }
    /**校验用户是否可用，并查询用户信息*/
    @GetMapping("/thirdpartyUsers")
    public Result<?> thirdpartyUsers(HttpServletRequest httpServletRequest,
                                     @RequestParam(name="name",required = false) String name,
                                     @RequestParam(name="username",required = false) String username,
                                     @RequestParam(name="knowledgeProjectId",required = false) String knowledgeProjectId,
                                     @RequestParam(name="pageNum",defaultValue = "1") Integer pageNum,
                                     @RequestParam(name="PageSize",defaultValue = "10") Integer PageSize){
        String token = httpServletRequest.getHeader("X-Access-Token");
        return authorizedUserService.thirdpartyUsers(token,name,username,knowledgeProjectId,pageNum,PageSize);
    }

    @GetMapping("/getAll")
    public Result<?> getAll(KbAuthorizedUser user){
        return authorizedUserService.getAll(user);
    }

    /**
     * 查看资讯有哪些人有权限查看
     * */
    @GetMapping("/knowBelongWho")
    public Result<?> knowBelongWho(
            @RequestParam(name="knowledgeProjectId") String knowledgeProjectId,
            @RequestParam(name="knowledgeId") String knowledgeId){
        return authorizedUserService.knowBelongWho(knowledgeProjectId,knowledgeId);
    }

}
