/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz2V;
import java.util.Map;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public class WindowsNativeCall {
    public static final byte DefaultPitch = 0;
    private static String zzXSY;
    private Map<String, Byte> zzXSX;
    private static boolean zzXSW;
    private static volatile WindowsNativeCall zzXSV;

    public native void createGlobalPrinterDC(String var1);

    public native void deleteGlobalPrinterDC();

    public native Map<String, Byte> getFontsPitchAndFamily();

    public native double[] getPrinterFontMetrics(String var1, float var2, int var3, byte var4);

    public native float getCharWidthPoints(int var1, String var2, float var3, int var4, byte var5);

    public native float getTextWidthPoints(String var1, String var2, float var3, int var4, byte var5);

    public float getTextWidthPointsSafe(String text, String fontName, float sizePoints, int fontStyle, byte pitchAndFamily) {
        if (text == null) {
            return 0.0f;
        }
        int n = text.length();
        if (n <= 10000) {
            return this.getTextWidthPoints(text, fontName, sizePoints, fontStyle, pitchAndFamily);
        }
        float f = 0.0f;
        for (int i = 0; i < n; ++i) {
            f += this.getCharWidthPoints(text.charAt(i), fontName, sizePoints, fontStyle, pitchAndFamily);
        }
        return f;
    }

    public static synchronized WindowsNativeCall getInstance() {
        if (!WindowsNativeCall.isPrinterGraphicsAvailable()) {
            throw new IllegalStateException("At the moment WindowsNativeCall can be used only on Windows and if there is at least one printer service available.");
        }
        if (zzXSV == null) {
            zzXSV = new WindowsNativeCall();
        }
        return zzXSV;
    }

    public Map<String, Byte> getFontsPitchAndFamilyCached() {
        return this.zzXSX;
    }

    private WindowsNativeCall() {
        this.createGlobalPrinterDC(zzXSY);
        this.zzXSX = this.getFontsPitchAndFamily();
    }

    public static boolean isPrinterGraphicsAvailable() {
        return zzXSW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<WindowsNativeCall> clazz = WindowsNativeCall.class;
        synchronized (WindowsNativeCall.class) {
            if (!zzXSW) {
                try {
                    PrintService printService;
                    if (zz2V.zzA2() && (printService = PrintServiceLookup.lookupDefaultPrintService()) != null) {
                        zzXSY = printService.getName();
                        zzXSW = true;
                    }
                }
                catch (Throwable throwable) {
                    System.err.println("Please make sure you have \"Visual C++ Redistributable Packages\" installed (see https://www.microsoft.com/en-us/download/details.aspx?id=30679)");
                    throwable.printStackTrace();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

