package com.zzsn.knowbase.kafka.message;

import com.zzsn.knowbase.entity.Content;
import com.zzsn.knowbase.entity.KnowFile;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 知识消息体
 *
 * @author ShiQiangChen
 * @date 2024/1/5
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class KnowledgeMessage {

    private String id;
    private String title;
    /**
     * 来源
     */
    private String origin;
    /**
     * 发布时间
     */
    private String publishDate;
    /**
     * 审核状态
     */
    private Integer verifyStatus;
    /**
     * 审核人名字
     */
    private String verifierName;
    /**
     * 知识库id
     */
    private String knowledgeProjectId;
    /**
     * 类型
     */
    private String type;

    private List<Content> contents;

}
