package com.zzsn.knowbase.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zzsn.knowbase.entity.KbAuthorizedUser;
import com.zzsn.knowbase.entity.KnowFile;
import com.zzsn.knowbase.entity.Knowledge;
import com.zzsn.knowbase.vo.KnowledgeParam;
import com.zzsn.knowbase.vo.KnowledgeVO;
import com.zzsn.knowbase.vo.Result;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @Description: 知识服务
 * @Author: chenshiqiang
 * @Version: V1.0
 */
public interface IKnowledgeService {


    /**
     * 新增
     */
    void addKnowledge(KnowFile knowFile, Knowledge knowledge, KbAuthorizedUser userInfo);

    /**
     * 修改
     */
    void updateKnowledge(Knowledge knowledge);

    /**
     * 删除
     */
    void deleteKnowledge(List<Knowledge> knowledgeList);

    void deleteForPython(String id, String knowledgeBaseId);

    /**
     * 分页检索
     *
     * @param knowledgeParam
     * @param pageNo
     * @param pageSize
     * @param column
     * @param order
     * @return
     */
    IPage<KnowledgeVO> queryPageList(KnowledgeParam knowledgeParam, Integer pageNo, Integer pageSize, String column, String order);

    List<KnowledgeVO> queryListByIds(String ids);

    IPage<KnowledgeVO> listFromPython(KnowledgeParam knowledgeParam, Integer pageNo, Integer pageSize, String column, String order);

    KnowledgeVO getById(String id);

    Result<?> doImportInfo(HttpServletRequest request,String userId);

    void doExcel(HttpServletRequest request, String fileSuffix,String userId);

    List<KnowledgeVO> listByIds(String ids);

    void exportExcel(String ids);

    String exportPackage(String ids);

    String comprocessByName(List<String> list, String filePath);
}
