package com.zzsn.knowbase.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.knowbase.entity.KbKnowledges;
import com.zzsn.knowbase.mapper.KbKnowledgesMapper;
import com.zzsn.knowbase.service.KbKnowledgesService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Service
public class KbKnowledgesServiceImpl extends ServiceImpl<KbKnowledgesMapper, KbKnowledges> implements KbKnowledgesService {

    @Override
    public List<KbKnowledges> syncSubjectConf() {
        LambdaQueryWrapper<KbKnowledges> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.isNotNull(KbKnowledges::getSubjectId);
        queryWrapper.ne(KbKnowledges::getSubjectId, "");
        queryWrapper.eq(KbKnowledges::getSyncStatus, 1);
        return this.list(queryWrapper);
    }
}
