package com.zzsn.knowbase.entity.subject;

import lombok.Data;

import java.util.List;

@Data
public class IntelligenceInfo {

    //作者
    private String author;
    private String authorRaw;
    //审核状态 (0：未审核  1：审核通过  2：审核未通过  3：暂定  4:重复数据  默认值为0)
    private Integer checkStatus;
    //发布状态 checkStatus=1时生效(0/null：待发布  1：已发布  2：已下架  默认值为null)
    private Integer publishStatus;
    //正文
    private String content;
    private String contentRaw;
    //带标签正文
    private String contentWithTag;
    private String contentWithTagRaw;
    //创建时间
    private String createDate;
    //删除标志
    private Integer deleteFlag;
    //id
    private String id;
    //关键词
    private String keyWords;
    //语言
    private String lang;
    //来源
    private String origin;
    private String originRaw;
    //发布时间
    private String publishDate;
    //得分
    private Double score;
    //信息源id
    private String sid;
    //地址
    private String sourceAddress;
    //专题id
    private String subjectId;
    //摘要
    private String summary;
    private String summaryRaw;
    //标题
    private String title;
    private String titleRaw;
    //置顶
    private Integer topNum;
    private String type;
    private List<Label> labels;

    //正负面
    private String orientation;
    //更新时间
    private String updateDate;

    //图片处理状态
    private String imgDisposeStatus;

    //数据类型 qbyw:情报要闻 qbnc:情报内参  cgbg: 常规报告
    private String dataType;
    //abi报表地址
    private String abiUrl;
    //abi报表id
    private String abiId;
    //栏目列表 对应栏目管理code字段
    private List<String> programaIds;
    //资源目录 对应资源目录管理code字段
    private String resourceCatalogId;
    //关键词列表
    private List<String> keyWordsList;
    //入专题库时间
    private String processDate;
}
