package com.zzsn.knowbase.vo;

import com.zzsn.knowbase.entity.Content;
import com.zzsn.knowbase.entity.KnowFile;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 知识参数
 *
 * @author ShiQiangChen
 * @date 2024/1/4
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class KnowledgeVO {
    private String id;
    private String title;
    private String publishDate;
    private String updateDate;
    private String createTime;
    private String kbKnowledgeId;
    private String KnowledgeProjectId;
    private String type;
    private String typeId;
    private String origin;
    private String author;
    private Integer score;
    private Integer importData;
    private String subjectId;
    private String contentWithTag;
    private String contentAll;
    private String sourceAddress;;
    private List<Content> contents;
    private List<KnowFile> files;

    /**
     * 审核时间
     */
    private String verifyTime;
    /**
     * 审核状态（0未审核1审核审核通过 2审核不通过）
     */
    private Integer verifyStatus;
    /**
     * 审核人id
     */
    private String verifierId;
    /**
     * 审核人名字
     */
    private String verifierName;
    private Integer deleteFlag;
    private String userId;
}
