package com.zzsn.knowbase.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zzsn.knowbase.entity.Knowledge;
import com.zzsn.knowbase.service.IKnowledgeService;
import com.zzsn.knowbase.util.DocUtil;
import com.zzsn.knowbase.util.HttpUtil;
import com.zzsn.knowbase.vo.IntelligentQaParam;
import com.zzsn.knowbase.vo.KnowledgeParam;
import com.zzsn.knowbase.vo.KnowledgeVO;
import com.zzsn.knowbase.vo.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Arrays;

/**
 * @Description: 知识
 * @Author: chenshiqiang
 * @Version: V1.0
 */
@Api(tags = "知识")
@RestController
@RequestMapping("/api/knowledge")
@Slf4j
public class KnowledgeController {
    @Autowired
    private IKnowledgeService knowledgeService;

    @Value("${python.IntelligentQaUrl:}")
    private String IntelligentQaUrl;

    /**
     * 分页列表查询
     */
    @GetMapping(value = "/list")
    public Result<?> queryPageList(KnowledgeParam knowledgeParam,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   @RequestParam(name = "column", defaultValue = "common") String column,
                                   @RequestParam(name = "order", defaultValue = "desc") String order) {
        IPage<KnowledgeVO> pageList = knowledgeService.queryPageList(knowledgeParam, pageNo, pageSize, column, order);

        return Result.OK(pageList);
    }
    /**
     * 添加
     *
     * @param knowledge
     * @return
     */
    @ApiOperation(value = "知识-添加", notes = "知识-添加")
    @PostMapping(value = "/uploadKnowledge")
    public Result<?> uploadKnowledge(HttpServletRequest request, @RequestBody Knowledge knowledge) {
        knowledgeService.addKnowledge(request,knowledge);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param knowledge
     * @return
     */
    @ApiOperation(value = "信息源组类别-编辑", notes = "信息源组类别-编辑")
    @PutMapping(value = "/edit")
    public Result<?> edit(@RequestBody Knowledge knowledge) {
        knowledgeService.updateKnowledge(knowledge);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @DeleteMapping(value = "/delete")
    public Result<?> delete(@RequestParam(name = "id") String id) {
        knowledgeService.deleteKnowledge(id);
        return Result.OK("删除成功!");
    }
    /**
     * 文档解析
     */
    @GetMapping(value = "/parse")
    public Result<?> parse(@RequestParam(name = "filePath")String filePath) throws IOException {
        String s = DocUtil.docParseHtml(filePath);
        return Result.OK(s);
    }

    /**
     * 智能问答
     *
     * @param intelligentQaParam
     * @return
     */
    @PostMapping(value = "/IntelligentQa")
    public Result<?> intelligentQa( IntelligentQaParam intelligentQaParam) throws IOException {
        JSONObject params  = new JSONObject();
        params.put("question",intelligentQaParam.getQuestion());
        params.put("knowledge_base_id",Arrays.asList(intelligentQaParam.getKnowledgeProjectIds().split(",")));
        String result = HttpUtil.doPost(IntelligentQaUrl, params, 120000);
        if(!result.isEmpty()){
            JSONObject jsonObject= JSON.parseObject(result);
            return Result.OK(jsonObject.get("result"));
        }
        return Result.error("响应失败");
    }
}
