/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz7O;
import asposewobfuscated.zz7R;
import asposewobfuscated.zzCM;
import asposewobfuscated.zzD1;
import asposewobfuscated.zzRV;
import asposewobfuscated.zzW;
import asposewobfuscated.zzZ;
import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.zz18;
import java.io.EOFException;
import java.io.InputStream;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static zzD1 zzZ9u = new zzD1();
    private static zzD1 zzZ9t = new zzD1();
    private static zzD1 zzZ9s = new zzD1();
    private static zzD1 zzZ9r = new zzD1();
    private static zzD1 zzZ9q = new zzD1();
    private static zzD1 zzZ9p = new zzD1();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZ.zzZ(fileName, "fileName");
        zz7R zz7R2 = zzZ.zzT(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zz4(zz7R2);
            return fileFormatInfo;
        }
        finally {
            ((zz7O)zz7R2).close();
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zz4(zzW.zzZ(stream));
    }

    static FileFormatInfo zz4(zz7O zz7O2) throws Exception {
        if (zz7O2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zz18 zz182 = new zz18();
            zz7O zz7O3 = zz7O2;
            zz18 zz183 = zz182;
            return zz182.zzY(zz7O3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZ(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzKT(zzRV.zzg(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzKY(zzRV.zzg(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string = zzRV.zzXS(FileFormatUtil.zzKV(loadFormat));
        if (zzCM.zzYE(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzKT(FileFormatUtil.zzKU(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzKY(FileFormatUtil.zzKV(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzRV.zzXS(FileFormatUtil.zzKU(saveFormat));
        if (zzCM.zzYE(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzKY(zzRV.zzf(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        int n = imageType;
        Object object = zzZ9s.get(n);
        return "." + zzRV.zzXS(object == null ? 0 : (Integer)object);
    }

    static Exception zzZ(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzKZ(int n) {
        return zzRV.toString(FileFormatUtil.zzKU(n));
    }

    static int zzKY(int n) {
        Object object = zzZ9q.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    static int zzKX(int n) {
        Object object = zzZ9p.get(n);
        if (object != null) {
            return (Integer)object;
        }
        return 1;
    }

    static boolean zzKW(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzKV(int n) {
        Object object = zzZ9u.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    static int zzKU(int n) {
        Object object = zzZ9t.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    private static int zzKT(int n) {
        Object object = zzZ9r.get(n);
        if (object == null) {
            return 255;
        }
        return (Integer)object;
    }

    static {
        Object[] objectArray = new Object[]{11, 10, 10, null, 11, null, 0, null, 12, 11, 11, null, 13, 20, 20, null, 13, null, 254, null, 14, 21, 21, null, 15, 22, 22, null, 16, 23, 23, null, 18, 24, 24, null, 19, 25, 25, null, 20, 26, 26, null, 21, 27, 27, null, 24, 30, 30, null, 17, 31, 31, null, 25, 50, 50, null, 26, 45, null, null, 27, 51, 51, null, 28, null, 52, null, 22, 60, 60, null, 23, 61, 61, null, 31, 40, null, null, 38, 47, null, null, 39, 48, null, null, 32, 41, null, null, 33, 46, null, null, 35, 42, null, null, 34, 44, null, null, 29, 52, null, null, 30, 70, 62, null, 36, 71, null, null, 8, 100, null, null, 9, 105, null, null, 6, 101, null, 6, 7, 102, null, 7, 5, 104, null, 5, 4, null, null, 4, 3, null, null, 3, 37, 72, null, null, 2, 103, null, 2};
        for (int i = 0; i < 156; i += 4) {
            Object object = objectArray[i];
            Object object2 = objectArray[i + 1];
            Object object3 = objectArray[i + 2];
            Object object4 = objectArray[i + 3];
            if (object2 != null) {
                zzZ9q.add((Integer)object, object2);
                zzZ9t.add((Integer)object2, object);
            }
            if (object3 != null) {
                if (!zzZ9r.contains((Integer)object)) {
                    zzZ9r.add((Integer)object, object3);
                }
                zzZ9u.add((Integer)object3, object);
            }
            if (object4 == null) continue;
            zzZ9p.add((Integer)object, object4);
            zzZ9s.add((Integer)object4, object);
        }
    }
}

