package com.zzsn.knowbase.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.zzsn.knowbase.entity.KbAuthorizedUser;
import com.zzsn.knowbase.vo.AddUserPermissKnowsVo;
import com.zzsn.knowbase.vo.Result;

import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
public interface KbAuthorizedUserService extends IService<KbAuthorizedUser> {

    Result<?> addOne(KbAuthorizedUser authorizedUser);

    Result<?> edit(KbAuthorizedUser authorizedUser);

    Result<?> lists(String roleId, String username, String name, String orgId, String orgName, String knowledgeProjectId, String category, Integer pageNum, Integer pageSize);

    Result<?> userPermission(String token);

    Result<?> thirdpartyUsers(String token, String name, String username, String knowledgeProjectId, Integer pageNum, Integer pageSize);

    Result<?> doCheck(String token);
    Result<?> doCheckAndGetUser(String token);

    /**
     * 已经在授权用户表存在的用户不会在授权用户表中重复存储。
     * 存储授权用户在某个节点下以及所有子节点的授权信息（如果这个用户在某个子节点已经有授权了，则不改变子节点之前的权限）
     * （顶级节点，”所有“）根节点授权的用户 只会存储本节点的用户权限信息
     * */
    Result<?> add(List<KbAuthorizedUser> authorizedUser);

    /**
     * 删除用户在某节点下的授权信息，删除后 如果所有节点都没有此用户的授权信息了，则删除授权用户
     * */
    Result<?> delById(String id, String knowledgeProjectId);

    Result<?> addUserPermitsKnows(AddUserPermissKnowsVo addUserPermissKnowsVo);

    Result<?>  getAll(KbAuthorizedUser user);

    Result<?> knowBelongWho(String knowledgeProjectId, String knowledgeId);

    Result<?> editBatch(List<KbAuthorizedUser> authorizedUsers);

    Result<?> operationAuthority(String knowledgeProjectId, String kbKnowledgeId, String operation);
}
