package com.zzsn.knowbase.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.zzsn.knowbase.entity.KbAuthorizedUser;
import com.zzsn.knowbase.entity.KbRole;
import com.zzsn.knowbase.vo.RolePermissonVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Mapper
public interface KbRoleMapper extends BaseMapper<KbRole> {

    @Select("SELECT a.*,p.id as permission_id,p.permission_code,p.permission_name  FROM kb_role a  " +
            "LEFT JOIN kb_role_permission_map b ON a.id = b.role_id " +
            "LEFT JOIN kb_permissions p on p.id = b.permission_id " +
            "${ew.customSqlSegment}"
    )
    List<RolePermissonVo> getRolePermission (@Param(Constants.WRAPPER) QueryWrapper<KbAuthorizedUser> query);
}
