package com.zzsn.knowbase.controller;

import com.zzsn.knowbase.entity.Knowledge;
import com.zzsn.knowbase.service.IKnowledgeService;
import com.zzsn.knowbase.service.ILocalFileService;
import com.zzsn.knowbase.vo.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/1/10 10:18
 * @Content:
 */
//@RestController
@Controller
@RequestMapping("/api/file")
public class KbFileController {

    @Autowired
    private ILocalFileService localFileService;
    @Autowired
    private IKnowledgeService knowledgeService;

    /**
     * 下载文档接口
     * @param fileName
     * @param filePath
     * @param response
     */
    @GetMapping("/download")
    public void download(String fileName, String filePath, HttpServletResponse response) {

        localFileService.download(fileName, filePath, response);

    }

    /**
     * 编辑文档接口
     * @param fileName
     * @param filePath
     * @param userName
     * @param model
     * @return
     */
    @GetMapping("/edit")
    public String editDocFile(String fileName, String filePath, String userName, Model model) {
        return localFileService.editDocFile(fileName,filePath,userName,model);
    }

    /**
     * 编辑文档时的回调接口
     * @param request
     * @param response
     * @throws IOException
     */
    @RequestMapping("/callback")
    public void saveDocumentFile(HttpServletRequest request, HttpServletResponse response) throws IOException {
        //处理编辑回调逻辑
        localFileService.callBack(request, response);

    }

    /**
     * 临时保存，保存并审核通过， 保存并审核不通过
     * @param request
     * @param knowledge
     * @return
     */
    @PostMapping(value = "/editKnowledge")
    public Result<?> editKnowledge(HttpServletRequest request, Knowledge knowledge) {

        //knowledgeService.addKnowledge();

        return null;

    }

}
