package com.zzsn.knowbase.service;

import com.zzsn.knowbase.entity.KnowFile;
import com.zzsn.knowbase.entity.Knowledge;
import com.zzsn.knowbase.vo.Result;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/1/9 9:34
 * @Content: 文件上传下载服务
 */
public interface ILocalFileService {

    /**
     * 文件上传
     * @param file
     * @return
     */
    Result<KnowFile> upload(MultipartFile file);

    /**
     * 批量文件上传
     * @param fileMap
     * @return
     */
    List<Result<KnowFile>> upload(Map<String,MultipartFile> fileMap);

    /**
     * 文件下载
     * @param
     * @param
     * @return
     */
    //ResponseEntity<Resource> download(String fileName, String filePath);
    void download(String fileName, String filePath, HttpServletResponse response);

    /**
     * 编辑文档
     * @param fileName
     * @param filePath
     * @param userName
     * @param model
     * @return
     */
    String editDocFile(String fileName, String filePath, String userName, Model model);

    /**
     * 编辑文档时的回调接口
     * @param request
     * @param response
     * @throws IOException
     */
    void callBack(HttpServletRequest request, HttpServletResponse response) throws IOException;


    Result<?> editKnowledge(Knowledge knowledge);


}
