/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import java.util.HashSet;
import java.util.Set;

public final class DocumentSecurity {
    public static final int NONE = 0;
    public static final int PASSWORD_PROTECTED = 1;
    public static final int READ_ONLY_RECOMMENDED = 2;
    public static final int READ_ONLY_ENFORCED = 4;
    public static final int READ_ONLY_EXCEPT_ANNOTATIONS = 8;
    public static final int length = 5;

    private DocumentSecurity() {
    }

    public static String getName(int documentSecurity) {
        switch (documentSecurity) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "PASSWORD_PROTECTED";
            }
            case 2: {
                return "READ_ONLY_RECOMMENDED";
            }
            case 4: {
                return "READ_ONLY_ENFORCED";
            }
            case 8: {
                return "READ_ONLY_EXCEPT_ANNOTATIONS";
            }
        }
        return "Unknown DocumentSecurity value.";
    }

    public static Set<String> getNames(int documentSecurity) {
        HashSet<String> hashSet = new HashSet<String>();
        if ((0 & documentSecurity) == 0) {
            hashSet.add("NONE");
        }
        if ((1 & documentSecurity) == 1) {
            hashSet.add("PASSWORD_PROTECTED");
        }
        if ((2 & documentSecurity) == 2) {
            hashSet.add("READ_ONLY_RECOMMENDED");
        }
        if ((4 & documentSecurity) == 4) {
            hashSet.add("READ_ONLY_ENFORCED");
        }
        if ((8 & documentSecurity) == 8) {
            hashSet.add("READ_ONLY_EXCEPT_ANNOTATIONS");
        }
        return hashSet;
    }

    public static String toString(int documentSecurity) {
        switch (documentSecurity) {
            case 0: {
                return "None";
            }
            case 1: {
                return "PasswordProtected";
            }
            case 2: {
                return "ReadOnlyRecommended";
            }
            case 4: {
                return "ReadOnlyEnforced";
            }
            case 8: {
                return "ReadOnlyExceptAnnotations";
            }
        }
        return "Unknown DocumentSecurity value.";
    }

    public static int fromName(String documentSecurityName) {
        if ("NONE".equals(documentSecurityName)) {
            return 0;
        }
        if ("PASSWORD_PROTECTED".equals(documentSecurityName)) {
            return 1;
        }
        if ("READ_ONLY_RECOMMENDED".equals(documentSecurityName)) {
            return 2;
        }
        if ("READ_ONLY_ENFORCED".equals(documentSecurityName)) {
            return 4;
        }
        if ("READ_ONLY_EXCEPT_ANNOTATIONS".equals(documentSecurityName)) {
            return 8;
        }
        throw new IllegalArgumentException("Unknown DocumentSecurity name.");
    }

    public static int fromNames(Set<String> documentSecurityNames) {
        int n = 0;
        for (String string : documentSecurityNames) {
            n |= DocumentSecurity.fromName(string);
        }
        return n;
    }

    public static int[] getValues() {
        return new int[]{0, 1, 2, 4, 8};
    }
}

