package com.zzsn.knowbase.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.knowbase.entity.*;
import com.zzsn.knowbase.mapper.KbAuthorizedUserMapper;
import com.zzsn.knowbase.service.*;
import com.zzsn.knowbase.vo.Result;
import com.zzsn.knowbase.vo.UserInfoVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author obcy
 * @since 2024-01-04
 */
@Service
public class KbAuthorizedUserServiceImpl extends ServiceImpl<KbAuthorizedUserMapper, KbAuthorizedUser> implements KbAuthorizedUserService {

    @Autowired
    KbUserRoleMapService kbUserRoleMapService;
    @Autowired
    KbAuthorizedUserMapper authorizedUserMapper;
    @Autowired
    KbRoleService roleService;
    @Autowired
    KbPermissionsService permissionsService;
    @Autowired
    KbRolePermissionMapService rolePermissionMapService;
    @Autowired
    KbAuthuserKnowledgeprojectMapService authuserKnowledgeprojectMapService;
    @Autowired
    KbKnowledgeProjectService knowledgeProjectService;

    /**
     * 校验第三方用户接口地址
     */
    @Value("${know.thirdpartyurl.checkuserurl:}")
    private String checkuserurl;

    /**
     * 获取第三方用户接口
     */
    @Value("${know.thirdpartyurl.getusersurl:}")
    private String getusersurl;

    @Override
    @Transactional
    public Result<?> addOne(KbAuthorizedUser authorizedUser) {
        /**保存授权用户*/
        authorizedUser.setStatus("0");
        authorizedUser.setCreateTime(new Date());
        super.save(authorizedUser);


        /**插入用户知识库权限关系表*/
        if (StringUtils.isNotBlank(authorizedUser.getKnowledgeProjectId())){
            KbAuthuserKnowledgeprojectMap kbAuthuserKnowledgeprojectMap = new KbAuthuserKnowledgeprojectMap();
            kbAuthuserKnowledgeprojectMap.setAuthUserId(authorizedUser.getId());
            kbAuthuserKnowledgeprojectMap.setKnowledgeProjectId(authorizedUser.getKnowledgeProjectId());
            authuserKnowledgeprojectMapService.save(kbAuthuserKnowledgeprojectMap);
            /**插入用户角色关系表*/
            if (StringUtils.isNotBlank(authorizedUser.getRoleId())){
                String roleId = authorizedUser.getRoleId();
                List<String> list = Arrays.asList(roleId.split(","));
                List<KbUserRoleMap> maps = new ArrayList<>();
                list.forEach(e->{
                    KbUserRoleMap kbUserRoleMap = new KbUserRoleMap();
                    kbUserRoleMap.setUserId(authorizedUser.getId());
                    kbUserRoleMap.setRoleId(e);
                    maps.add(kbUserRoleMap);
                });
                kbUserRoleMapService.saveBatch(maps);
            }
        }
        return  Result.OK();
    }

    @Override
    public Result<?> add(List<KbAuthorizedUser>   authorizedUsers) {

        if (CollectionUtil.isEmpty(authorizedUsers)){
            return  Result.error("请选择要授权的用户");
        }

        Map<String, List<KbAuthorizedUser>> reqUsersMap = authorizedUsers.stream().collect(Collectors.groupingBy(KbAuthorizedUser::getUserId));

        List<KbAuthorizedUser> kbAuthorizedUsers = authorizedUserMapper.selectList(Wrappers.<KbAuthorizedUser>lambdaQuery()
                .in(KbAuthorizedUser::getUserId, authorizedUsers.stream().map(KbAuthorizedUser::getUserId).collect(Collectors.toList())));

        List<String> collect = kbAuthorizedUsers.stream().map(KbAuthorizedUser::getUserId).collect(Collectors.toList());


        //已经授权过的用户在用户表里不用重复插入
        List<KbAuthorizedUser> notExist = authorizedUsers.stream().filter(f -> !collect.contains(f.getUserId())).collect(Collectors.toList());

        authorizedUsers = new ArrayList<>();
        authorizedUsers.addAll(notExist);

        if (CollectionUtil.isNotEmpty(authorizedUsers)) {
            authorizedUsers.forEach(e-> {
                /**保存授权用户*/
                e.setStatus("0");
                e.setCreateTime(new Date());
            });
            super.saveBatch(authorizedUsers);
        }
        if (CollectionUtil.isNotEmpty(kbAuthorizedUsers)){
            kbAuthorizedUsers.forEach(e->{
                e.setRoleId(reqUsersMap.get(e.getUserId()).get(0).getRoleId());
                e.setKnowledgeProjectId(reqUsersMap.get(e.getUserId()).get(0).getKnowledgeProjectId());
            });
            authorizedUsers.addAll(kbAuthorizedUsers);
        }

        //获取这一批下面的其中一个用户，获取这批用户关联的知识库分类
        KbAuthorizedUser kbAuthorizedUser = authorizedUsers.get(0);
        if (!"0".equals(kbAuthorizedUser.getKnowledgeProjectId())) {

            //查询授权节点和其子节点，一起授权
            List<KbKnowledgeProject> projectTypes = knowledgeProjectService.list(Wrappers.<KbKnowledgeProject>lambdaQuery().like(KbKnowledgeProject::getFullPath, kbAuthorizedUser.getKnowledgeProjectId()));

            //去除已经受过权的节点
            List<String> thisBanth = authorizedUsers.stream().map(KbAuthorizedUser::getId).collect(Collectors.toList());
            List<KbAuthuserKnowledgeprojectMap> list1 = authuserKnowledgeprojectMapService.list(Wrappers.<KbAuthuserKnowledgeprojectMap>lambdaQuery().in(KbAuthuserKnowledgeprojectMap::getAuthUserId, thisBanth));
            Map<String, List<KbAuthuserKnowledgeprojectMap>> collect1Map = list1.stream().collect(Collectors.groupingBy(KbAuthuserKnowledgeprojectMap::getAuthUserId));


            List<KbUserRoleMap> maps = new ArrayList<>();
            List<KbAuthuserKnowledgeprojectMap> userknows = new ArrayList<>();

            authorizedUsers.forEach(authorizedUser->{

                List<KbKnowledgeProject> projectTypesFi = new ArrayList<>();
                //此用户已经受过权限的知识库分类
                List<KbAuthuserKnowledgeprojectMap> kbAuthuserKnowledgeprojectMaps = collect1Map.get(authorizedUser.getId());

                if (CollectionUtil.isNotEmpty(kbAuthuserKnowledgeprojectMaps)){
                    List<String> collect1 = kbAuthuserKnowledgeprojectMaps.stream().map(KbAuthuserKnowledgeprojectMap::getKnowledgeProjectId).collect(Collectors.toList());
                    projectTypesFi  = projectTypes.stream().filter(f -> !collect1.contains(f.getId())).collect(Collectors.toList());
                }else {
                    projectTypesFi = projectTypes;
                }

                /**插入用户知识库分类权限关系表*/
                if (CollectionUtil.isNotEmpty(projectTypesFi)){
                    projectTypesFi.forEach(e -> {
                        KbAuthuserKnowledgeprojectMap kbAuthuserKnowledgeprojectMap = new KbAuthuserKnowledgeprojectMap();
                        kbAuthuserKnowledgeprojectMap.setAuthUserId(authorizedUser.getId());
                        kbAuthuserKnowledgeprojectMap.setKnowledgeProjectId(e.getId());
                        kbAuthuserKnowledgeprojectMap.setSign(0);
                        kbAuthuserKnowledgeprojectMap.setCreateDate(new Date());
                        userknows.add(kbAuthuserKnowledgeprojectMap);
                        /**插入用户角色关系表*/
                        if (StringUtils.isNotBlank(authorizedUser.getRoleId())){
                            String roleId = authorizedUser.getRoleId();
                            List<String> list = Arrays.asList(roleId.split(","));
                            list.forEach(ee->{
                                KbUserRoleMap kbUserRoleMap = new KbUserRoleMap();
                                kbUserRoleMap.setUserId(authorizedUser.getId());
                                kbUserRoleMap.setRoleId(ee);
                                kbUserRoleMap.setKnowledgeProjectId(e.getId());
                                kbUserRoleMap.setCreateDate(new Date());
                                maps.add(kbUserRoleMap);
                            });
                        }
                    });

                }
            });

            kbUserRoleMapService.saveBatch(maps);
            authuserKnowledgeprojectMapService.saveBatch(userknows);
        }else {
            authorizedUsers.forEach(authorizedUser->{
                /**插入用户知识库权限关系表*/
                if (StringUtils.isNotBlank(authorizedUser.getKnowledgeProjectId())){
                    KbAuthuserKnowledgeprojectMap kbAuthuserKnowledgeprojectMap = new KbAuthuserKnowledgeprojectMap();
                    kbAuthuserKnowledgeprojectMap.setAuthUserId(authorizedUser.getId());
                    kbAuthuserKnowledgeprojectMap.setKnowledgeProjectId(authorizedUser.getKnowledgeProjectId());
                    authuserKnowledgeprojectMapService.save(kbAuthuserKnowledgeprojectMap);

                }
                /**插入用户角色关系表*/
                if (StringUtils.isNotBlank(authorizedUser.getRoleId())){
                    String roleId = authorizedUser.getRoleId();
                    List<String> list = Arrays.asList(roleId.split(","));
                    List<KbUserRoleMap> maps = new ArrayList<>();
                    list.forEach(e->{
                        KbUserRoleMap kbUserRoleMap = new KbUserRoleMap();
                        kbUserRoleMap.setUserId(authorizedUser.getId());
                        kbUserRoleMap.setRoleId(e);
                        kbUserRoleMap.setKnowledgeProjectId(authorizedUser.getKnowledgeProjectId());
                        maps.add(kbUserRoleMap);
                    });
                    kbUserRoleMapService.saveBatch(maps);
                }
            });
        }


        return  Result.OK();
    }

    @Override
    public Result<?> delById(String id, String knowledgeProjectId) {
        //移除知识库分类节点下所有的子节点下的这个用户
        List<KbKnowledgeProject> knowPros = knowledgeProjectService.list(Wrappers.<KbKnowledgeProject>lambdaQuery()
                .like(KbKnowledgeProject::getFullPath, knowledgeProjectId)
        );
        List<String> knowProIds = knowPros.stream().map(KbKnowledgeProject::getId).collect(Collectors.toList());
        kbUserRoleMapService.remove(Wrappers.<KbUserRoleMap>lambdaQuery()
                .eq(KbUserRoleMap::getUserId,id)
                .in(KbUserRoleMap::getKnowledgeProjectId,knowProIds)
        );
        authuserKnowledgeprojectMapService.remove(Wrappers.<KbAuthuserKnowledgeprojectMap>lambdaQuery()
                .eq(KbAuthuserKnowledgeprojectMap::getAuthUserId,id)
                .in(KbAuthuserKnowledgeprojectMap::getKnowledgeProjectId,knowProIds));
        return Result.OK();
    }


    @Override
    @Transactional
    public Result<?> edit(KbAuthorizedUser authorizedUser) {
        String newRole = authorizedUser.getRoleId();
        String knowProId = authorizedUser.getKnowledgeProjectId();
        authorizedUser.setUpdateTime(new Date());
        super.updateById(authorizedUser);
        /**修改用户角色关系表*/
        if (StringUtils.isNotBlank(newRole)){
            //所编辑知识库分类节点下所有的子节点
            List<KbKnowledgeProject> knowPros = knowledgeProjectService.list(Wrappers.<KbKnowledgeProject>lambdaQuery()
                    .like(KbKnowledgeProject::getFullPath, knowProId)
            );


            List<String> knowProIds = knowPros.stream().map(KbKnowledgeProject::getId).collect(Collectors.toList());

            kbUserRoleMapService.remove(Wrappers.<KbUserRoleMap>lambdaQuery()
                    .eq(KbUserRoleMap::getUserId,authorizedUser.getId())
                    .in(KbUserRoleMap::getKnowledgeProjectId,knowProIds)
            );

            List<String> list = Arrays.asList(newRole.split(","));
            List<KbUserRoleMap> maps = new ArrayList<>();
            list.forEach(e->{
                knowProIds.forEach(ee->{
                    KbUserRoleMap kbUserRoleMap = new KbUserRoleMap();
                    kbUserRoleMap.setUserId(authorizedUser.getId());
                    kbUserRoleMap.setRoleId(e);
                    kbUserRoleMap.setKnowledgeProjectId(ee);
                    kbUserRoleMap.setCreateDate(new Date());
                    maps.add(kbUserRoleMap);
                });

            });
            kbUserRoleMapService.saveBatch(maps);

        }
        return Result.OK();
    }



    @Override
    public Result<?> lists(String roleId, String username, String name, String orgId, String orgName, String knowledgeProjectId, String category, Integer pageNum, Integer pageSize) {
        QueryWrapper<KbAuthorizedUser> query = new QueryWrapper<>();
        Page<KbAuthorizedUser> page = new Page<>(pageNum, pageSize);

        query.eq(StringUtils.isNotBlank(username),"a.username",username);
        query.eq(StringUtils.isNotBlank(orgId),"a.org_id",orgId);
        query.eq(StringUtils.isNotBlank(roleId),"b.role_id",roleId);
        query.eq(StringUtils.isNotBlank(knowledgeProjectId),"d.knowledge_project_id",knowledgeProjectId);
        query.eq(StringUtils.isNotBlank(knowledgeProjectId),"b.knowledge_project_id",knowledgeProjectId);
        query.like(StringUtils.isNotBlank(name),"a.name",name);
        query.like(StringUtils.isNotBlank(orgName),"a.org_name",orgName);


        //根据一些条件动态的关联表
        String sql = "";
        IPage<KbAuthorizedUser> res = authorizedUserMapper.pageList(page, query);
        return Result.OK(res);
    }

    @Override
    public Result<?> userPermission(String token) {
        /**调用第三方系统校验接口*/
        Result res =  doCheck(token);
        boolean success = res.isSuccess();
        if(200 == res.getCode() && success){
            /**校验成功，获取到第三方用户信息*/
            KbAuthorizedUser bean = JSONUtil.toBean(JSONUtil.toJsonStr(res.getResult()), KbAuthorizedUser.class);
            /**校验第三方用户是否进行了授权*/
            List<KbAuthorizedUser> list = super.list(Wrappers.<KbAuthorizedUser>lambdaQuery().eq(KbAuthorizedUser::getUserId, bean.getUserId()));
            if (CollectionUtil.isEmpty(list)){
                return Result.error("该用户还未进行授权访问，请联系管理员进行授权");
            }
            /**查询授权用户的角色和权限*/
            UserInfoVo userInfoVo = new UserInfoVo();
            QueryWrapper<KbAuthorizedUser> query = new QueryWrapper<>();
            query.eq("a.user_id",bean.getUserId());
            KbAuthorizedUser one = authorizedUserMapper.getOne(query);
            /**是否是所有节点的管理员*/
            List<KbAuthuserKnowledgeprojectMap> list1 = authuserKnowledgeprojectMapService.list(Wrappers.<KbAuthuserKnowledgeprojectMap>lambdaQuery()
                    .eq(KbAuthuserKnowledgeprojectMap::getAuthUserId, one.getId())
                    .eq(KbAuthuserKnowledgeprojectMap::getKnowledgeProjectId, "0")
                    .eq(KbAuthuserKnowledgeprojectMap::getSign, 0)
            );

            if (CollectionUtil.isNotEmpty(list1)){
                one.setIsAll(0);
            }else {
                one.setIsAll(1);
            }

            List<KbRole> kbRoles = roleService.listByIds(Arrays.asList(one.getRoleId().split(",")));

            List<KbRolePermissionMap> permissionMaps = rolePermissionMapService.list(Wrappers.<KbRolePermissionMap>lambdaQuery().in(KbRolePermissionMap::getRoleId, Arrays.asList(one.getRoleId().split(","))));

//            Map<Long, List<KbRolePermissionMap>> collect = permissionMaps.stream().collect(Collectors.groupingBy(KbRolePermissionMap::getRoleId));
//            List<KbPermissions> permissions = new ArrayList<>();
//            kbRoles.forEach(e->{
//                List<Long> longs = CollectionUtil.isEmpty(collect.get(e.getId())) ? new ArrayList<Long>() : collect.get(e.getId()).stream().map(KbRolePermissionMap::getPermissionId).collect(Collectors.toList());
//                if (CollectionUtil.isNotEmpty(longs)) {
//                    e.setPermissions(permissionsService.list(Wrappers.<KbPermissions>lambdaQuery().in(KbPermissions::getId,longs)));
//                }
//            });
            if (CollectionUtil.isNotEmpty(permissionMaps)) {
                List<KbPermissions> permissions = permissionsService.list(Wrappers.<KbPermissions>lambdaQuery().in(KbPermissions::getId, permissionMaps.stream().map(KbRolePermissionMap::getPermissionId).collect(Collectors.toList())));
                userInfoVo.setPermissions(permissions);
            }
            userInfoVo.setRoles(kbRoles);
            userInfoVo.setAuthorizedUser(one);
            return Result.OK(userInfoVo);
        }else {
            return Result.error("第三方系统未通过用户校验");
        }
    }

    @Override
    public Result<?> thirdpartyUsers(String token, String name, String username, Integer pageNum, Integer pageSize) {
        String body = HttpRequest.get(getusersurl).header("X-Access-Token", token)
                .form("pageNum",pageNum)
                .form("pageSize",pageSize)
                .form("name",name)
                .form("username",username)
                .execute().body();
        Result bean = JSONUtil.toBean(body, Result.class);

        Page page = JSONUtil.toBean(JSONUtil.toJsonStr(bean.getResult()), Page.class);

        List<KbAuthorizedUser> list = JSONUtil.toList(JSONUtil.parseArray(JSONUtil.toJsonStr(page.getRecords())), KbAuthorizedUser.class);
        Page<KbAuthorizedUser> result = new Page<>();
        result.setTotal(page.getTotal());
        result.setCurrent(page.getCurrent());
        result.setSize(page.getSize());
        result.setRecords(list);
        return Result.OK(result);
    }


    @Override
    public Result<?> doCheck(String token) {
        String body = HttpRequest.post(checkuserurl).header("X-Access-Token", token).execute().body();
        Result bean = JSONUtil.toBean(body, Result.class);
        return  bean;
    }
    @Override
    public Result<?> doCheckAndGetUser(String token) {
/**调用第三方系统校验接口*/
        Result res =  doCheck(token);
        boolean success = res.isSuccess();
        if(200 == res.getCode() && success) {
            /**校验成功，获取到第三方用户信息*/
            KbAuthorizedUser bean = JSONUtil.toBean(JSONUtil.toJsonStr(res.getResult()), KbAuthorizedUser.class);
            /**校验第三方用户是否进行了授权*/
            List<KbAuthorizedUser> list = super.list(Wrappers.<KbAuthorizedUser>lambdaQuery().eq(KbAuthorizedUser::getUserId, bean.getUserId()));
            if (CollectionUtil.isEmpty(list)) {
                return Result.error("该用户还未进行授权访问，请联系管理员进行授权");
            }
            /**查询授权用户*/
            QueryWrapper<KbAuthorizedUser> query = new QueryWrapper<>();
            query.eq("a.user_id",bean.getUserId());
            KbAuthorizedUser one = authorizedUserMapper.getOne(query);
            /**是否是所有节点的管理员*/
            List<KbAuthuserKnowledgeprojectMap> list1 = authuserKnowledgeprojectMapService.list(Wrappers.<KbAuthuserKnowledgeprojectMap>lambdaQuery()
                    .eq(KbAuthuserKnowledgeprojectMap::getAuthUserId, one.getId())
                    .eq(KbAuthuserKnowledgeprojectMap::getKnowledgeProjectId, "0")
                    .eq(KbAuthuserKnowledgeprojectMap::getSign, 0)
            );

            if (CollectionUtil.isNotEmpty(list1)){
                one.setIsAll(0);
            }else {
                one.setIsAll(1);
            }
            return Result.OK(one);
        }else {
            return Result.error("第三方系统未通过用户校验");
        }
    }


}
