package com.zzsn.knowbase.util;


import com.github.tobato.fastdfs.proto.storage.DownloadByteArray;
import com.obs.services.ObsClient;
import com.obs.services.model.*;
//import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.ArrayList;
import java.util.List;

/**
 * Description: obs桶文件操作
 * Author: EDY
 * Date: 2023/10/9
 */
@Component
public class ObsUtil {

    @Autowired
    ObsClient obsClient;
    /**桶名称*/
    private String bucketName = "zzsn";

    /**判断桶是否存在*/
    public Boolean existsBucket(String bucket){
       return obsClient.headBucket(bucket);
    }
    public Boolean existsBucket(){
        return obsClient.headBucket(bucketName);
    }

    /**
     * 创建文件夹本质上来说是创建了一个大小为0且对象名以“/”结尾的对象。
     * 多级文件夹创建最后一级即可，比如src1/src2/src3/，创建src1/src2/src3/即可，无需创建src1/、src1/src2/。
     * keySuffixWithSlash为文件夹名称，以 / 结尾
     * */
    public boolean mkdir(String keySuffixWithSlash){
        PutObjectResult putObjectResult = obsClient.putObject(bucketName, keySuffixWithSlash, new ByteArrayInputStream(new byte[0]));
        if (putObjectResult.getStatusCode()==200) {
            return  true;
        }else {
            return false;
        }
    }

    /**查询桶内文件夹下所有文件
     * folderPrefix 为文件夹名称，以 / 结尾
     * */
    public List<ObsObject> getPathFileList(String folderPrefix){
        List<ObsObject> res = new ArrayList<>();
        ListObjectsRequest request = new ListObjectsRequest(bucketName);
        request.setPrefix(folderPrefix);
        ObjectListing result = obsClient.listObjects(request);
        for (ObsObject obsObject : result.getObjects()) {
            res.add(obsObject);
        }
        return  res;
    }
    /**
     * 获取文件夹下的文件数量
     * */
    public Integer getCount (String folderPrefix){
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucketName);
        listObjectsRequest.setPrefix(folderPrefix);
        listObjectsRequest.setMaxKeys(1000);
        int fileCount = 0;

        ObjectListing objectListing;

        do {
            objectListing = obsClient.listObjects(listObjectsRequest);

            List<S3Object> objectSummaries = objectListing.getObjectSummaries();
            fileCount += objectSummaries.size();

            String nextMarker = objectListing.getNextMarker();
            listObjectsRequest.setMarker(nextMarker);
        } while (objectListing.isTruncated());

        return fileCount;
    }

    /**删除桶内文件
     * objectKey为文件路径，起始为桶内某文件夹，或者直接为桶内文件
     * */
    public boolean delFile (String objectKey){
        DeleteObjectResult deleteObjectResult = obsClient.deleteObject(bucketName, objectKey);
        if (deleteObjectResult.getStatusCode()==200) {
            return  true;
        }else {
            return false;
        }
    }

    /**文件上传
     * objectKey为文件路径
     * */
    public PutObjectResult uploadFile(String objectKey,byte[] bytes){
        PutObjectResult putObjectResult = obsClient.putObject(bucketName, objectKey, new ByteArrayInputStream(bytes));
        return putObjectResult;
    }
    /**文件上传
     * objectKey为文件路径
     * */
    public PutObjectResult uploadFile(String objectKey ,InputStream inputStream){
        PutObjectResult putObjectResult = obsClient.putObject(bucketName, objectKey, inputStream);
        return putObjectResult;
    }
    /**
     * 获取文件流
     *
     * */
    public InputStream getObjectStream(String objectKey){
        ObsObject obsObject = obsClient.getObject(bucketName, objectKey);
        return obsObject.getObjectContent();
    }
    /**
     * 获取文件流
     *
     * */
    public  byte[] getObjectByte(String objectKey){
        ObsObject obsObject = obsClient.getObject(bucketName, objectKey);
        // 获取文件的输入流
        InputStream objectContent = obsObject.getObjectContent();

        // 将输入流转换为byte[]
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int bytesRead;
        while (true) {
            try {
                if (!((bytesRead = objectContent.read(buffer)) != -1)) {
                    break;
                }
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
            byteArrayOutputStream.write(buffer, 0, bytesRead);
        }
        byte[] fileBytes = byteArrayOutputStream.toByteArray();
        return fileBytes;
    }

    /*
     * 文件预览
     * @param fileName
     */
    public boolean previewImg(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filePath = request.getParameter("attachmentPath");
        String group = request.getParameter("group");
        if (StringUtils.isBlank(filePath)) {
            return false;
        }
        DownloadByteArray downloadByteArray = new DownloadByteArray();
        byte[] content = getObjectByte(filePath);
        if (content == null || content.length == 0) {
            return false;
        }

        response.addHeader("Pragma", "No-cache");
        response.addHeader("Cache-Control", "no-store,No-cache");
        response.setCharacterEncoding("UTF-8");
//        response.setContentType("application/json;charset=utf-8");
        String s = filePath.split("/")[filePath.split("/").length - 1];
        String mimeType = request.getServletContext().getMimeType(s);
        System.out.println("文件类型为" + mimeType);
        response.setContentType(request.getServletContext().getMimeType(s) + ";charset=utf-8");
        OutputStream out = response.getOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(out);
        try {
            bos.write(content, 0, content.length);
            bos.flush();
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (bos != null) {
                bos.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return true;
    }

}
