/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzT;
import com.aspose.words.net.System.Data.zzU;
import com.aspose.words.net.System.Data.zzV;
import com.aspose.words.net.System.Data.zzX;
import com.aspose.words.net.System.Data.zzY;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzXQq = new DataRowCollection(this);
    private final DataColumnCollection zzXQp = new DataColumnCollection(this);
    private final ConstraintCollection zzXQo = new ConstraintCollection(this);
    private final zzT zzXQn = new zzT(this);
    private ResultSet zzXQm;
    private String zzZcF;
    private DataSet zz4D;
    private String zzZ2I = "";
    private UniqueConstraint zzXQl;
    private boolean zzXQB = true;
    private final List<DataTableEventListener> zzXQk = new ArrayList<DataTableEventListener>();
    private final Set<DataRow> zzXQj = new HashSet<DataRow>();

    public DataTable() {
    }

    public DataTable(String tableName) {
        this.zzZcF = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        this(resultSet, zzY.zzZ(resultSet));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzXQm = resultSet;
        this.zzZcF = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzXQm != null) {
            if (this.zzXQm.getStatement() != null) {
                this.zzXQm.getStatement().getConnection().close();
            }
            this.zzXQm = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzZcF;
    }

    public void setTableName(String tableName) {
        this.zzZcF = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzXQp.getCount();
    }

    public String getColumnName(int index) {
        return this.zzXQp.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzXQm;
    }

    public DataSet getDataSet() {
        return this.zz4D;
    }

    final void zzZ(DataSet dataSet) {
        this.zz4D = dataSet;
    }

    public DataRowCollection getRows() {
        return this.zzXQq;
    }

    public DataColumnCollection getColumns() {
        return this.zzXQp;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzXQo;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzXQl == null) {
            return new DataColumn[0];
        }
        return this.zzXQl.getColumns();
    }

    final void zzT(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzXQl != null) {
                this.zzXQl.zzQP(false);
                this.getConstraints().remove(this.zzXQl);
                this.zzXQl = null;
            }
            return;
        }
        if (this.zzXQl != null && DataColumn.areColumnSetsTheSame(value, this.zzXQl.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzZ(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzXQl != null) {
            this.zzXQl.zzQP(false);
            this.getConstraints().remove(this.zzXQl);
            this.zzXQl = null;
        }
        UniqueConstraint.zzZ(this.getConstraints(), uniqueConstraint);
        this.zzXQl = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZ2I;
    }

    public void setNamespace(String namespace) {
        this.zzZ2I = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzXQB;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzXQB = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzXQj.clear();
            this.getRows().clear();
            this.getColumns().clear();
            DataTable dataTable = this;
            ResultSet resultSet = this.getResultSet();
            for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                String string = resultSetMetaData.getColumnName(i);
                DataColumn dataColumn = new DataColumn(string, dataTable, i);
                dataColumn.setAllowDBNull(resultSetMetaData.isNullable(i) == 1);
                dataColumn.setAutoIncrement(resultSetMetaData.isAutoIncrement(i));
                dataColumn.setReadOnly(resultSetMetaData.isReadOnly(i));
                try {
                    dataColumn.setDataType(Class.forName(resultSetMetaData.getColumnClassName(i)));
                }
                catch (ClassNotFoundException classNotFoundException) {}
                dataTable.getColumns().add(dataColumn);
            }
            zzY.zzZ(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            sQLException.printStackTrace();
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzY.zzY(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzXQk.contains(listener)) {
            this.zzXQk.add(listener);
        }
    }

    public void removeEventListener(zzX listener) {
        if (this.zzXQk.contains(listener)) {
            this.zzXQk.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzXQk.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzXQj.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXQk) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzXQj.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXQk) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzXQj.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzXQk) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXQk) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzXQk) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final boolean zzZ(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2, DataRow dataRow) {
        DataTable dataTable;
        DataRow dataRow2 = dataRow;
        DataColumn[] dataColumnArray3 = dataColumnArray2;
        DataColumn[] dataColumnArray4 = dataColumnArray;
        DataTable dataTable2 = dataTable = this;
        zzU zzU10 = dataTable.zzXQn.zzX(dataColumnArray4);
        return zzU10.zzxi(zzV.zzZ(dataColumnArray3, dataRow2));
    }

    final zzT zzZ9t() {
        return this.zzXQn;
    }

    final Set<DataRow> zzZ9s() {
        return this.zzXQj;
    }
}

