package com.zzsn.knowbase.util;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.zwobble.mammoth.DocumentConverter;
import org.zwobble.mammoth.Result;

import java.io.File;
import java.io.IOException;
import java.util.Set;

/**
 * 文档工具
 *
 * @author chenshiqiang
 */
@Slf4j
@Component
public class DocUtil {


    /**
     * 文档解析
     */
    public static  String docParseHtml(String filePath) throws IOException {
        DocumentConverter converter = new DocumentConverter()
                .disableDefaultStyleMap()
//                .addStyleMap("p[style-name='Section Title'] => h1:fresh")
//                .addStyleMap("p[style-name='Subsection Title'] => h2:fresh")
                ;
        Result<String> result = converter.convertToHtml(new File(filePath));
        // The generated HTML
        String html = result.getValue();
        // Any warnings during conversion
        Set<String> warnings = result.getWarnings();
        return html;
    }

}
