package com.zzsn.knowbase.util;

import org.apache.commons.lang3.StringUtils;

import javax.net.ssl.*;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class FileUtil {

	private static ArrayList<String> readFileName = new ArrayList<String>();
	
	public static InputStream  DownloadFileFormServer(String strUrl) {
		InputStream inputStream = null;
		try {
			URL url = new URL(strUrl);
			if(strUrl.contains("https")){
				//忽略证书
				SSLContext sc = SSLContext.getInstance("SSL");
				sc.init(null, new TrustManager[]{
					new X509TrustManager() {
						@Override
						public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
						}

						@Override
						public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
						}

						@Override
						public X509Certificate[] getAcceptedIssuers() {
							return new X509Certificate[0];
						}
					}
				}, new SecureRandom());
				HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
				conn.setRequestProperty("Accept-Encoding", "deflate");
				conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36");
				// 设置证书忽略相关操作
				conn.setSSLSocketFactory(sc.getSocketFactory());
				conn.setHostnameVerifier(new HostnameVerifier() {
					@Override
					public boolean verify(String s, SSLSession sslSession) {
						return true;
					}
				});
				conn.setRequestMethod("GET");
				conn.setConnectTimeout(20 * 1000);
				conn.connect();
				inputStream = conn.getInputStream();
			}else{
				HttpURLConnection conn = (HttpURLConnection) url.openConnection();
				conn.setRequestProperty("Accept-Encoding", "deflate");
				conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36");
				conn.setRequestMethod("GET");
				conn.setConnectTimeout(20 * 1000);
				conn.connect();
				inputStream = conn.getInputStream();
			}
		} catch (Exception e) {
		} finally {
		}
		return inputStream;
	}
	public static int getFileSizeByUrl(String strUrl){
		try {
			URL url = new URL(strUrl);
			if(strUrl.contains("https")){
				//忽略证书
				SSLContext sc = SSLContext.getInstance("SSL");
				sc.init(null, new TrustManager[]{
						new X509TrustManager() {
							@Override
							public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
							}

							@Override
							public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
							}

							@Override
							public X509Certificate[] getAcceptedIssuers() {
								return new X509Certificate[0];
							}
						}
				}, new SecureRandom());
				HttpsURLConnection conn = (HttpsURLConnection) url.openConnection();
				conn.setRequestProperty("Accept-Encoding", "deflate");
				conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36");
				// 设置证书忽略相关操作
				conn.setSSLSocketFactory(sc.getSocketFactory());
				conn.setHostnameVerifier(new HostnameVerifier() {
					@Override
					public boolean verify(String s, SSLSession sslSession) {
						return true;
					}
				});
				conn.setRequestMethod("GET");
				conn.setConnectTimeout(20 * 1000);
				conn.connect();
				return conn.getContentLength();
			}else{
				HttpURLConnection conn = (HttpURLConnection) url.openConnection();
				conn.setRequestProperty("Accept-Encoding", "deflate");
				conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36");
				conn.setRequestMethod("GET");
				conn.setConnectTimeout(20 * 1000);
				conn.connect();
				return conn.getContentLength();
			}
		} catch (Exception e) {
		}
		return 0;
	}
	/*
	 * 清空文件列表中的记录
	 */
	public static void clearList() {
		readFileName.clear();
	}

	public static ArrayList<String> getReadFileName() {
		return readFileName;
	}

	public static void setReadFileName(ArrayList<String> readFileName) {
		FileUtil.readFileName = readFileName;
	}

	/*
	 * 
	 * 通过递归得到某一路径下所有的目录及其文件
	 * 
	 */
	public static void getFiles(String filePath) {
		File root = new File(filePath);
		File[] files = root.listFiles();
		for (File file : files) {
			if (file.isDirectory()) {
				/*
				 * 
				 * 递归调用
				 * 
				 */
				getFiles(file.getAbsolutePath());
			} else {
				String absolutePath = file.getAbsolutePath();

				String regex = ".*[\\d]{4}年--[\\d]{1,2}月.*";
				Matcher m = Pattern.compile(regex).matcher(absolutePath);
				if (absolutePath != null && m.matches() && absolutePath.indexOf("--进出口--") == -1) {
					readFileName.add(file.getAbsolutePath());
				}
			}
		}

	}

	public static List<String> readFiletoList(String fileName) {

		List<String> list = new ArrayList<String>();
		BufferedReader br = null;
		InputStream is = null;

		InputStreamReader isr = null;
		try {
			is = new FileInputStream(fileName);
			isr = new InputStreamReader(is, "gb2312");
			br = new BufferedReader(isr);
			// br = new BufferedReader(new FileReader(fileName),"gb2312");
			String contentLine;
			while ((contentLine = br.readLine()) != null) {
				if (StringUtils.isNotEmpty(contentLine)) {
					contentLine = contentLine.trim();
					list.add(contentLine);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (br != null) {
				try {
					br.close();

				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			if (isr != null) {
				try {
					isr.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			if (is != null) {
				try {
					is.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		return list;

	}

	/*
	 * 保存操作日志到文件
	 * 没有调用的地方
	 */
	public static void saveProjectInfo(String page,String fileName) {
		BufferedWriter bw1 = null;
		try {
			bw1 = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName, true)));
			bw1.write(page + "\r\n");
			bw1.flush();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			if (bw1 != null) {
				try {
					bw1.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
	}

}
