package com.zzsn.csmfagov.server.impl;

import com.zzsn.csmfagov.server.CsmfagovServer;
import com.zzsn.csmfagov.util.EsDateUtil;
import com.zzsn.csmfagov.util.EsUtil;
import com.zzsn.csmfagov.vo.BaseData;
import com.zzsn.csmfagov.vo.Result;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/3/14 11:06
 * @Content:
 */
@Service
@Slf4j
public class CsmfagovServerImpl implements CsmfagovServer {

    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private EsUtil esUtil;

    private static final String CSMFAGE_LAST_TIME = "csmfageLastTime";

    @Override
    public Result<?> getData(String groupId) {
        Object object = redisTemplate.opsForValue().get(CSMFAGE_LAST_TIME + "_" + groupId);

        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders
                .boolQuery()
                .must(QueryBuilders.termsQuery("sid", Arrays.asList("1534597839834664962", "1534597844930744322"))
                );
        if (object != null) {
            String startTime = object.toString();
            boolQueryBuilder.filter(QueryBuilders.rangeQuery("createDate").gte(EsDateUtil.esFieldDateFormat(startTime)));
        }
        searchSourceBuilder.query(boolQueryBuilder);
        searchSourceBuilder.sort("createDate", SortOrder.DESC);
        List<BaseData> list = esUtil.queryList("basedata", searchSourceBuilder, BaseData.class);

        redisTemplate.opsForValue().set(CSMFAGE_LAST_TIME + "_" + groupId, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss")));

        if(list.size() == 0){
            return Result.OK("没有新增数据！",list);
        }
        return Result.OK(list);
    }
}
