package com.zzsn.csmfagov.util;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.util.*;

/**
 * Description: es数据操作工具类
 * Author: EDY
 * Date: 2023/7/28
 */
@Component
@Slf4j
public class EsUtil {
    /*es客户端*/
    @Autowired
    RestHighLevelClient client;


    /**
     * 获取低级客户端
     *
     * @return
     */
    public RestClient getLowLevelClient() {
        return client.getLowLevelClient();
    }

    /**
     * 根据index,id索引文件
     *
     * @param index
     * @param id
     * @return
     */
    public <T> T getInfoByid(String index, String id, Class<T> entry) {
        T res = null;
        try {
            GetRequest searchRequest = new GetRequest(index, id);
            GetResponse documentFields = client.get(searchRequest, RequestOptions.DEFAULT);
            res = JSON.parseObject(documentFields.getSourceAsString(), entry);
            return  res;
        } catch (IOException e) {
            log.warn("查询doc异常，index=[{}],id=[{}], ex=[{}]", index, id, e.getMessage());
        }
        return res;
    }
    /**
     * 根据id查询各类资讯详情
     * */
    public <T> T getInfoByid1(String index, String id, Class<T> entry){
        try {
            SearchRequest searchRequest = new SearchRequest(index);
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            TermQueryBuilder termQueryBuilder = QueryBuilders.termQuery("id", id);
            searchSourceBuilder.query(termQueryBuilder);
            searchRequest.source(searchSourceBuilder);
            SearchResponse searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHit[] hits = searchResponse.getHits().getHits();
            T res = null;
            if (hits.length>0){
                res = JSON.parseObject(hits[0].getSourceAsString(), entry);
            }
            return  res;
        } catch (IOException e) {
            log.info("查询异常{}",e.getMessage(),e);
            return  null;
        }

    }
    /**
     * 通用查询，
     * */
    public <T> List<T> queryList(String index, SearchSourceBuilder searchSourceBuilder, Class<T> entry) {
        List<T> list = new ArrayList<>();

        try {
            SearchRequest searchRequest = new SearchRequest(index);
            searchRequest.source(searchSourceBuilder);
            searchSourceBuilder.size(1000);
            SearchResponse searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            // 处理搜索结果
            SearchHit[] hits = searchResponse.getHits().getHits();
            if (hits.length>0){
                Arrays.stream(hits).forEach(e -> {
                    T t = JSON.parseObject(e.getSourceAsString(), entry);
                    list.add(t);
                });
            }
            return list;
        } catch (IOException e) {
            log.info("查询异常{}",e.getMessage(),e);
            return list;
        }
    }





}
