package com.zzsn.csmfagov.server.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.zzsn.csmfagov.server.QixinServer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.nio.charset.StandardCharsets;
import java.util.*;
import com.mashape.unirest.http.*;

@Service
@Slf4j
public class QixinServerImpl implements QixinServer {

    //59.5 主要人员对外投资任职信息
    String baseUrl = "https://api.qixin.com/APIService/personInfo/getNPInvestAndPositionByName";
    String appkey = "2e46b0d9-7352-43c0-b800-9d7f5e1de8e5";
    String secretKey = "b6183639-2045-47fb-9640-90905e7b53b6";

    @Override
    public String getNPInvestAndPositionByName(String company, String name) {
        Calendar calendar = Calendar.getInstance();
        Long timestamp = calendar.getTime().getTime();
        String sign = getMD5Str(appkey + timestamp + secretKey);

        // 设置url参数
        Map<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("company", company);
        urlParams.put("name", name);

        List<String> concatParams = new ArrayList<String>();
        for (String s : urlParams.keySet()) {
            try {
                concatParams.add(s + "=" + URLEncoder.encode(urlParams.get(s), "UTF-8"));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        Unirest.setTimeouts(0, 2000);
        try {
            // 发送get请求，得到响应
            HttpResponse<String> response = Unirest.get(baseUrl + "?" + String.join("&", concatParams))
                    .header("Auth-version", "2.0")
                    .header("appkey", appkey)
                    .header("timestamp", timestamp + "")
                    .header("sign", sign)
                    .header("Content-Type", "application/json")
                    .asString();

            String body = response.getBody();
            log.info("body---{}",body);
            JSONObject jsonObject = JSON.parseObject(body, JSONObject.class);
            String status = jsonObject.getString("status");
            Integer statusInt = Integer.valueOf(status);
            //响应状态码在200-209时直接返回
            if(statusInt >= 200 && statusInt <= 209){
                JSONObject data = jsonObject.getJSONObject("data");
                JSONArray invest_info = data.getJSONArray("invest_info"); //股东信息列表 1
                JSONArray oper_info = data.getJSONArray("oper_info"); //法人代表信息列表 2
                JSONArray manager_info = data.getJSONArray("manager_info"); //高管信息列表 3

                JSONArray resJSONArray = new JSONArray();
                if(invest_info != null && invest_info.size() > 0){
                    for(int i = 0; i < invest_info.size(); i++){
                        JSONObject jj = invest_info.getJSONObject(i);
                        jj.put("type", "1");
                    }
                    resJSONArray.addAll(invest_info);

                }
                if(oper_info != null && oper_info.size() > 0){
                    for (int i = 0;i < oper_info.size(); i++){
                        JSONObject jj = oper_info.getJSONObject(i);
                        jj.put("type", "2");
                    }
                    resJSONArray.addAll(oper_info);
                }
                if(manager_info != null && manager_info.size() > 0){
                    for(int i = 0; i < manager_info.size(); i++){
                        JSONObject jj = manager_info.getJSONObject(i);
                        jj.put("type","3");
                    }
                    resJSONArray.addAll(manager_info);
                }

                jsonObject.put("data", resJSONArray);
                return JSON.toJSONString(jsonObject);
            } else {
                JSONObject res = new JSONObject();
                res.put("status","500");
                res.put("message","操作失败，请联系技术人员");
                return JSON.toJSONString(res);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject res = new JSONObject();
        res.put("status","501");
        res.put("message","接口异常，请联系技术人员");
        return JSON.toJSONString(res);
    }


    // 获取字符串的md5值
    private String getMD5Str(String str) {
        byte[] digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            digest = md.digest();

            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                String s = String.format("%02x", b);
                sb.append(s);
            }
            return sb.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
