package com.zzsn.csmfagov.server.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.zzsn.csmfagov.server.QixinServer;
import com.zzsn.csmfagov.vo.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.nio.charset.StandardCharsets;
import java.util.*;
import com.mashape.unirest.http.*;

@Service
@Slf4j
public class QixinServerImpl implements QixinServer {

    String baseUrl = "https://api.qixin.com/APIService/personInfo/getNPInvestAndPositionByName";
    String appkey = "2e46b0d9-7352-43c0-b800-9d7f5e1de8e5";
    String secretKey = "b6183639-2045-47fb-9640-90905e7b53b6";

    @Override
    public String getNPInvestAndPositionByName(String company, String name) {
        Calendar calendar = Calendar.getInstance();
        Long timestamp = calendar.getTime().getTime();
        String sign = getMD5Str(appkey + timestamp + secretKey);

        // 设置url参数
        Map<String, String> urlParams = new HashMap<String, String>();
        urlParams.put("company", company);
        urlParams.put("name", name);

        List<String> concatParams = new ArrayList<String>();
        for (String s : urlParams.keySet()) {
            try {
                concatParams.add(s + "=" + URLEncoder.encode(urlParams.get(s), "UTF-8"));
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }

        Unirest.setTimeouts(0, 2000);
        try {
            // 发送get请求，得到响应
            HttpResponse<String> response = Unirest.get(baseUrl + "?" + String.join("&", concatParams))
                    .header("Auth-version", "2.0")
                    .header("appkey", appkey)
                    .header("timestamp", timestamp + "")
                    .header("sign", sign)
                    .header("Content-Type", "application/json")
                    .asString();

            String body = response.getBody();
            log.info("body---{}",body);
            JSONObject jsonObject = JSON.parseObject(body, JSONObject.class);
            String status = jsonObject.getString("status");
            Integer i = Integer.valueOf(status);
            //响应状态码在200-209时直接返回
            if(i >= 200 && i <= 209){
                return body;
            } else {
                JSONObject res = new JSONObject();
                res.put("status","500");
                res.put("message","操作失败，请联系技术人员");
                return JSON.toJSONString(res);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
        JSONObject res = new JSONObject();
        res.put("status","501");
        res.put("message","接口异常，请联系技术人员");
        return JSON.toJSONString(res);
    }


    // 获取字符串的md5值
    private String getMD5Str(String str) {
        byte[] digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            digest = md.digest();

            StringBuilder sb = new StringBuilder();
            for (byte b : digest) {
                String s = String.format("%02x", b);
                sb.append(s);
            }
            return sb.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}
