package com.zzsn.csmfagov.controller;

import com.zzsn.csmfagov.server.QixinServer;
import com.zzsn.csmfagov.vo.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 启信宝接口对外提供服务
 */
@RestController
@RequestMapping("/personInfo/api")
@Slf4j
public class QixinController {

    @Autowired
    QixinServer qixinServer;

    /**
     * 59.5 主要人员对外投资任职信息
     * @param company
     * @param name
     * @return
     */
    @GetMapping("/getNPInvestAndPositionByName")
    public String getNPInvestAndPositionByName(
            @RequestParam(name="company") String company,
            @RequestParam(name="name") String name){
        log.info("查询入参:{}---{}", company, name);

        return qixinServer.getNPInvestAndPositionByName(company, name);
    }
}
