package com.zzsn.csmfagov.controller;

import com.zzsn.csmfagov.server.CsmfagovServer;
import com.zzsn.csmfagov.vo.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/2/6 11:06
 * @Content:
 */
@RestController
@RequestMapping("/csmfagov/api")
@Slf4j
public class CsmfagovController {

    @Autowired
    CsmfagovServer csmfagovServer;

    @GetMapping("/test")
    public String test(){
        log.info("hello!");
        return "hello!";
    }

    @GetMapping("/getData")
    public Result<?> getData(@RequestParam(name="groupId",required=false) String groupId){
        log.info("groupId:{}", groupId);
        //处理参数，groupId为空时默认给一个固定的
        if(groupId == null || groupId.length() == 0){
            groupId = "default";
        }
        return csmfagovServer.getData(groupId);
    }


}
