package com.zzsn.collection.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/8/10 16:00
 * @Content:
 */

@Data
@TableName("collection_info_source")
public class CollectionInfoSource {
    //主键
    private String id;

    //信息源编码
    private String infoSourceCode;

    //栏目名称
    private String siteName;

    //资讯url
    private String url;

    //成功次数
    private int successNum;

    //失败次数
    private int failNum;

    //备注信息
    private String remark;

    //创建时间
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

}
