package com.zzsn.collection.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import com.zzsn.collection.entity.CollectionInfoSource;
import com.zzsn.collection.entity.SiteMsgTemple;
import com.zzsn.collection.service.CollectionInfoSourceService;
import com.zzsn.collection.util.FileUtil;
import com.zzsn.collection.util.HttpUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import com.alibaba.fastjson.JSONObject;

import java.io.File;
import java.util.Date;
import java.util.List;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/8/10 11:17
 * @Content: 项目启动后立即执行
 */
@Component
@Slf4j
public class CommandLineRunnerImpl implements CommandLineRunner {

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private CollectionInfoSourceService collectionInfoSourceService;


    @Value("${file.info-source-path}")
    private String INFO_SOURCE_PATH;

    //列表
    private String verifyListUrlJN = "http://114.115.154.140:9010/crawlerVerify/listPage";//境内列表
    private String verifyListUrlJW = "http://114.115.151.210:9010/crawlerVerify/listPage";//境外列表
    //详情
    private String verifyDetailUrlJN = "http://114.115.154.140:9010/crawlerVerify/detailPage";//境内列表
    private String verifyDetailUrlJW = "http://114.115.151.210:9010/crawlerVerify/detailPage";//境外列表

    @Override
    public void run(String... args) throws Exception {
        log.info("信息源可用验证任务启动！");

        String filepath= INFO_SOURCE_PATH;
        log.info("信息源验证文件："+filepath);

        try {
            File f = new File(filepath);
            List<String> allLines = FileUtil.getFileLines(f, "utf-8");
            log.info("信息源数量"+allLines.size());

            for (String keysite : allLines) {
                String value = redisTemplate.opsForValue().get("INFO_SOURCE_TO_REDIS::" + keysite);
                SiteMsgTemple siteMsgTemple = new Gson().fromJson(value, SiteMsgTemple.class);

                if(!yanzheng(siteMsgTemple)){
                    //第一次失败
                    yanzheng(siteMsgTemple);
                }
            }

        }catch (Exception e){
            e.getMessage();
        }

    }

    public Boolean yanzheng(SiteMsgTemple siteMsgTemple){
        String infoSourceCode = siteMsgTemple.getInfoSourceCode();
        String siteName = siteMsgTemple.getSiteName();
        String siteUri = siteMsgTemple.getSiteUri();
        log.info("验证信息源：{}---栏目名称：{}---栏目地址：{}", infoSourceCode, siteName, siteUri);
        try {
            String checkedList = siteMsgTemple.getCheckedList();//是否翻墙
            boolean contains = checkedList == null ? false : checkedList.contains("3");
            String result;//验证结果
            Boolean mark = false;//列表页验证是否成功标识
            if(contains){
                //境外
                result = HttpUtil.doPost(verifyListUrlJW, (JSONObject)JSONObject.toJSON(siteMsgTemple), 5*60*1000);
            } else {
                //境内
                result = HttpUtil.doPost(verifyListUrlJN, (JSONObject)JSONObject.toJSON(siteMsgTemple), 5*60*1000);
            }
            if(result != null){
                JSONObject jsonObject = JSON.parseObject(result);
                JSONObject data = (JSONObject) jsonObject.get("data");
                if(data.size() > 0){
                    Integer matchUrlNum = Integer.parseInt(data.getString("matchUrlNum"));
                    if(matchUrlNum > 0){
                        mark = true;
                    }
                }
            }

            if(mark){
                //列表页验证成功，验证详情页
                String resultDetail;//验证结果
                if(contains){
                    //境外
                    resultDetail = HttpUtil.doPost(verifyDetailUrlJW, (JSONObject)JSONObject.toJSON(siteMsgTemple), 5*60*1000);
                } else {
                    //境内
                    resultDetail = HttpUtil.doPost(verifyDetailUrlJN, (JSONObject)JSONObject.toJSON(siteMsgTemple), 5*60*1000);
                }
                if(resultDetail != null){
                    JSONObject jsonObject = JSON.parseObject(resultDetail);
                    JSONObject data = (JSONObject) jsonObject.get("data");
                    if(data.size() > 0){
                        String content = data.getString("content");
                        String publishDate = data.getString("publishDate");
                        if(content != null && content.length() > 0 && publishDate != null && publishDate.length() > 0){
                            //验证通过
                            insertCollInfo(siteMsgTemple, true, "");
                        } else {
                            insertCollInfo(siteMsgTemple, false, "正文或发布时间为空，");
                        }
                    } else {
                        insertCollInfo(siteMsgTemple, false, "详情页验证失败，");
                    }
                } else {
                    insertCollInfo(siteMsgTemple, false, "详情页验证失败，");
                }
            } else {
                insertCollInfo(siteMsgTemple, false, "列表页验证失败，");
            }
            return null;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     *
     * @param siteMsgTemple
     * @param b 成功标志
     * @param remark
     */
    public void insertCollInfo(SiteMsgTemple siteMsgTemple, Boolean b, String remark){
        CollectionInfoSource coll = collectionInfoSourceService.getById(siteMsgTemple.getId());
        if (coll == null){
            CollectionInfoSource newColl = new CollectionInfoSource();
            newColl.setId(siteMsgTemple.getId());
            newColl.setInfoSourceCode(siteMsgTemple.getInfoSourceCode());
            newColl.setSiteName(siteMsgTemple.getSiteName());
            newColl.setUrl(siteMsgTemple.getSiteUri());
            if(b){
                newColl.setSuccessNum(1);
            } else {
                newColl.setFailNum(1);
            }
            newColl.setRemark(remark);
            newColl.setCreateTime(new Date());
            collectionInfoSourceService.save(newColl);
        } else {
            if(b){
                coll.setSuccessNum(coll.getSuccessNum() + 1);
            } else {
                coll.setFailNum(coll.getFailNum() + 1);
            }
            coll.setRemark(coll.getRemark() + remark);
            collectionInfoSourceService.updateById(coll);
        }
    }
}
