package com.zzsn.collection.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.zzsn.collection.entity.CollectionLog;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/5/25 14:54
 * @Content:
 */
@Mapper
public interface CollectionLogMapper extends BaseMapper<CollectionLog> {


//    @Select("select * from collection_log where type = 1 and info_source_code = #{infoSourceCode} limit 10")
    @Select("select * from collection_log where type = 1 limit 10")
    List<CollectionLog> getJobLog(String infoSourceCode);


    @Select("select a.name,a.code,b.countSource,c.countInfo from collection_enum a " +
            "LEFT JOIN ( " +
            "select server_code,count(*) as countSource from collection_log " +
            "where type = 1 " +
            "and create_time > #{createDate} " +
            "group by server_code " +
            ") b " +
            "on a.code = b.server_code " +
            "LEFT JOIN ( " +
            "select server_code,count(*) as countInfo from collection_log " +
            "where type = 2 " +
            "and create_time > #{createDate} " +
            "group by server_code " +
            ") c " +
            "on a.code = c.server_code " +
            "where type = 'statistics' " +
            "ORDER BY a.sort asc ")
    List<Map<String, String>> statistics(String createDate);
}
