package com.zzsn.collection.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zzsn.collection.entity.CollectionLog;
import com.zzsn.collection.mapper.CollectionLogMapper;
import com.zzsn.collection.service.CollectionLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/5/24 16:19
 * @Content:
 */
@Component
@Slf4j
public class CollectionLogServiceImpl extends ServiceImpl<CollectionLogMapper, CollectionLog> implements CollectionLogService {


    @Override
    public List<CollectionLog> getJobLog(String infoSourceCode) {
//        LambdaQueryWrapper<CollectionLog> lambdaQuery = Wrappers.lambdaQuery();
//        lambdaQuery.eq(CollectionLog::getType, 1);
//        List<CollectionLog> list = baseMapper.selectList(lambdaQuery);

        List<CollectionLog> list = baseMapper.getJobLog(infoSourceCode);

        return list;
    }

    @Override
    public List<Map<String, String>> statistics(String createDate) {
        List<Map<String, String>> list = baseMapper.statistics(createDate);
        return list;
    }
}
