package com.zzsn.collection.entity;

import lombok.Data;

import java.io.Serializable;
import java.util.regex.Pattern;

@Data
public class SiteMsgTemple implements Serializable {
    private static final long serialVersionUID = 1L;

    /**主键*/
    private String id;
    /**信息源编码*/
    private String infoSourceCode;
    /**信息源名称*/
    private String webSiteName;
    /**栏目名称*/
    private String siteName;
    /**栏目地址*/
    private String siteUri;
    /**语种*/
    private String language;
    /**境外、公共、翻墙*/
    private String checkedList;
    /**历史数据URL*/
    private String hisUriExp;
    /**历史数据开始时间*/
//    private java.util.Date hisDateStartTime;
    private String hisDateStartTime;
    /**历史数据结束时间*/
//    private java.util.Date hisDateEndTime;
    private String hisDateEndTime;
    /**是否历史所有数据*/
    private String ynHisDataAll;
    /**网站级别*/
    private String  siteLevel;
    /**状态*/
    private Integer status;
    /**列表页URL*/
    private String listUrl;
    /**表达式类型*/
    private String listExpressionType;
    /**
     * 列表信息块位置
     */
    private String infoBlockPosition;
    /**
     *抽取链接定位
     */
    private String linkLocation;
    /**匹配资讯的列表*/
    private String informationItem;
    /**匹配资讯的url*/
    private String informationUrl;
    /**匹配资讯标题*/
    private String informationTitle;
    /**匹配资讯发布时间*/
    private String informationPublishDate;
    /**匹配资讯来源*/
    private String informationSource;
    /**自定义实体*/
    private Object extractInfo;
    /**爬取深度*/
    private Integer crawlDepth;
    /**页码url*/
    private String pageUrl;
    /**匹配页码*/
    private String matchPage;
    /**开始页码*/
    private Integer pageStart;
    /**结束页码*/
    private Integer pageEnd;
    /**是否所有页*/
    private String ynPageAll;
    /**表达式类型*/
    private String detailExpressionType;
    /**详情页表URL*/
    private String detailUrl;
    /**匹配详情页标题*/
    private String detailExpressionTitle;
    /**匹配详情页时间*/
    private String detailExpressionPublishDate;
    /**匹配详情页来源*/
    private String detailExpressionSource;
    /**匹配详情页作者*/
    private String detailExpressionAuthor;
    /**匹配详情页摘要*/
    private String detailExpressionSummary;
    /**匹配详情页正文*/
    private String detailExpressionContent;
    /**自定义实体*/
    private Object detailInfo;
    /**是否下载附件*/
    private String ynDownload;
    /**数据表格页URL*/
    private String formUrl;
    /**数据表格标题*/
    private String formTitle;
    /**表达式类型*/
    private Integer formType;
    /**数据表格表达式*/
    private String dataFormExpression;
    /**自定义*/
    private Object dataFormInfo;
    /**页码URL*/
    private String dataPageUrl;
    /**页码规则*/
    private String dataPageRule;
    /**开始页码*/
    private Integer dataPageStart;
    /**结束页码*/
    private Integer dataPageEnd;
    /**是否所有页码*/
    private String ynDataPageAll;
    /**数据类型*/
    private Integer dataType;
    /**数据格式*/
    private Integer dataFormat;
    /**数据存储方式*/
    private Integer dataStorageMode;
    /**数据存储信息*/
    private Object dataStorageInfo;
    /**是否动态爬取*/
    private Integer ynDynamicCrawl;
    /**是否需要登陆*/
    private Integer ynLogin;
    /**登陆域名*/
    private String domainName;
    /**登陆链接*/
    private String link;
    /**登陆账号*/
    private String account;
    /**登陆密码*/
    private String password;
    /**userAgent*/
    private String userAgent;
    /**referer*/
    private String referer;
    /**cookies*/
    private String cookies;
    /**headers*/
    private String headers;
    /**其它参数*/
    private String otherInfo;
    /**爬虫类别*/
    private Integer crawlType;
    /**爬虫名称*/
    private String crawlName;
    /**爬虫地址*/
    private String crawlAddress;
    /**参数*/
    private Object parameter;
    /**cron表达式*/
    private String cron;

//    /**是否需要快照*/
//    private String isScreenshot;

//++++++++++++++++++++++++++++++++++++++++++++++++++
    private Pattern pattern;

    /**是否保存快照（1：保存   0：不保存）*/
    private String ynSnapshot;

    /**是否为验证方法（1：是验证   0：不是）*/
    private String verifyType;
}
