package com.zzsn.collection.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Version 1.0
 * @Author: ZhangJingKun
 * @Date: 2024/5/24 16:51
 * @Content:
 */
@Data
@TableName("collection_log")
public class CollectionLog {

    //主键
    private String id;
    //类别 1定时任务 2采集情况
    private Integer type;
    //信息源id
    private String sid;
    //信息源编码
    private String infoSourceCode;
    //栏目名称
    private String siteName;
    //程序标识
    private String serverCode;
    //标题
    private String title;
    //资讯唯一标识
    private String uniqueCode;
    //资讯url
    private String url;
    //备注信息
    private String remark;
    //创建时间
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    //备用字段
    private String coll1;
    private String coll2;
    private String coll3;

}
