# -*- coding: utf-8 -*-
"""
任务集成测试
1、连接redis做取出
2、连接kafka做信息的获取，与存储

"""
import time

import redis
from kafka import KafkaProducer
from kafka import KafkaConsumer
import json
import itertools
from qqnewspider import QQnewsSpider

import concurrent.futures
from baseCore import BaseCore
from queue import Queue
import configparser

class QQnewsTaskJob(object):
    def __init__(self):
        # 创建ConfigParser对象
        self.config = configparser.ConfigParser()
        # 读取配置文件
        self.config.read('config.ini')
        self.r = redis.Redis(host=self.config.get('redis', 'host'),
                             port=self.config.get('redis', 'port'),
                             password=self.config.get('redis', 'pass'), db=0)

    def getkafka(self):
        # Kafka集群的地址
        bootstrap_servers = self.config.get('kafka', 'bootstrap_servers')
        # 要订阅的主题
        topic = self.config.get('kafka', 'topic')
        groupId=self.config.get('kafka', 'groupId')
        consumer = KafkaConsumer(topic, group_id=groupId,
                                 bootstrap_servers=[bootstrap_servers],
                                 value_deserializer=lambda m: json.loads(m.decode('utf-8')))
        try:
            for record in consumer:
                try:
                    logger.info("value:",record.value)
                    keymsg=record.value
                    if keymsg:
                        break
                    else:
                        continue
                #print("%s:%d:%d: key=%s value=%s" % (msg.topic, msg.partition, msg.offset, msg.key, msg.value))
                except Exception as e:
                    logger.info("msg.value error:",e)
        except KeyboardInterrupt as e:
            keymsg={}
        finally:
            consumer.close()

        return keymsg

    def getkeyFromredis(self,codeid):
        kvalue=self.r.get('KEY_WORDS_TO_REDIS::'+codeid)
        kvalue=kvalue.decode('utf-8')
        kvalue=json.loads(kvalue)
        return kvalue

    def getkeywords(self,keywords):
        kwList=[]
        if ')+(' in keywords:
            k1List=keywords.split('+')
            kk2=[]
            for k2 in k1List:
                k2=k2.strip("()")
                k2List=k2.split('|')
                kk2.append(k2List)
            if len(kk2)==2:
                result = list(itertools.product(kk2[0], kk2[1]))
            elif len(kk2)==3:
                result = list(itertools.product(kk2[0], kk2[1],kk2[2]))
            elif len(kk2)==4:
                result = list(itertools.product(kk2[0], kk2[1],kk2[2],kk2[3]))


            for res in result:
                kwstr=''
                for kw in res:
                    kwstr+=kw+"+"
                kwList.append(kwstr.strip('+'))
        elif '+(' in keywords:
            k1List=keywords.split('+')
            kk2=[]
            for k2 in k1List:
                k2=k2.strip("()")
                k2List=k2.split('|')
                kk2.append(k2List)
            if len(kk2)==2:
                result = list(itertools.product(kk2[0], kk2[1]))

            for res in result:
                kwstr=''
                for kw in res:
                    kwstr+=kw+"+"
                kwList.append(kwstr.strip('+'))
        else:
            k3=keywords.split("|")
            kwList=k3
        return kwList


    def paserKeyMsg(self,keymsg):
        logger.info('----------')
        wordsCode=keymsg['wordsCode']
        id=keymsg['id']
        # try:
        #     searchEngines=keymsg['searchEngines']
        #     if 'java.util.ArrayList' in searchEngines:
        #         searchEngines=searchEngines[1]
        # except Exception as e:
        #     searchEngines=[]
        kwList=[]
        searchEngines=['3']
        if searchEngines:
            if '3' in searchEngines:
                keyword=keymsg['keyWord']
                keymsglist=self.getkeywords(keyword)
                for kw in keymsglist:
                    kwmsg={
                        'kw':kw,
                        'wordsCode':wordsCode,
                        'sid':id
                    }
                    kwList.append(kwmsg)
            else:
                logger.info('+++++')
        else:
            logger.info('+++++searchEngines为空')
            keyword=keymsg['keyWord']
            keymsglist=self.getkeywords(keyword)
            for kw in keymsglist:
                kwmsg={
                    'kw':kw,
                    'wordsCode':wordsCode,
                    'sid':id
                }
                kwList.append(kwmsg)

        return kwList

    def runSpider(self,kwmsg):
        searchkw=kwmsg['kw']
        wordsCode=kwmsg['wordsCode']
        sid=kwmsg['sid']
        qqnewsSpider=QQnewsSpider(searchkw,wordsCode,sid)
        try:
            qqnewsSpider.get_page_html()
        except Exception as e:
            logger.info('搜狗搜索异常'+searchkw)

        if qqnewsSpider.detailList.qsize() != 0:
            try:
                qqnewsSpider.get_detail_html()
            except Exception as e:
                logger.info('详情解析异常'+searchkw)
        logger.info("关键词采集结束！"+searchkw)

    def lockwMsg(self):
        kwList=[]
        kwLstr='浙江银通典当有限责任公司|浙江省化工进出口有限公司|浙江省能源集团有限公司|浙江海港中奥能源有限责任公司|杭州香格里拉饭店有限公司|浙能集团新疆准东能源化工有限公司|温州衢化东南工贸有限公司|义乌产权交易所有限公司|温州机场集团有限公司|浙江浙能电力股份有限公司|浙江工程设计有限公司|浙江国信控股集团有限责任公司|浙江巨化集团进出口有限公司|上海盛东国际集装箱码头有限公司|衢州巨化房地产开发有限公司|浙江省空港融资租赁有限公司|浙江中旅商务会展有限公司|浙江海港集团财务有限公司|浙江浙能港口运营管理有限公司|浙江机场集团保安服务有限公司|新疆塔建三五九建工有限责任公司|浙江能源天然气集团有限公司|浙江华江科技股份有限公司|浙江浙能资产经营管理有限公司|浙江海港黄泽山油品储运有限公司|浙江浙旅投资有限责任公司|浙江海港海洋工程建设有限公司|浙江省能源集团财务有限责任公司|江西省赣浙能源有限公司|温州联合产权交易中心有限公司|浙江省通用航空产业发展有限公司|物产中大期货有限公司|浙江省富浙融资租赁有限公司|宁波机场集团有限公司|浙江省振兴乡村建设投资发展集团有限公司|浙江杭钢融资租赁有限公司|浙江国贸云商控股有限公司|浙江省农村实业发展有限公司|巨化控股有限公司|浙江省国际贸易集团有限公司|浙江机电职业技术学院|浙江头门港投资开发有限公司|伊犁新天煤化工有限责任公司|浙江省农村发展集团农产品有限公司|衢州巨化传媒有限公司|浙江机场投资有限责任公司|浙江中大元通融资租赁有限公司|巨化集团公司兴化实业有限公司|浙江新世纪期货有限公司|巨化集团有限公司|浙旅盛景资本投资有限公司|浙江省医疗健康集团有限公司|浙江歌瑞新材料有限公司|浙江省国贸集团资产经营有限公司|浙能资本控股有限公司|杭州萧山国际机场有限公司|浙江梅苑酒店管理有限公司|浙江国贸集团东方机电工程股份有限公司|上港集团平湖独山港码头有限公司|浙江巨化热电有限公司|浙江省粮食集团有限公司|宁波舟山港集团有限公司|浙江省纺织品进出口集团有限公司|浙江巨化物流有限公司|浙江建设技师学院|浙江杭州临空经济开发有限公司|浙江中大技术进出口集团有限公司|浙江省粮油食品进出口股份有限公司|浙江省石油股份有限公司|浙江空港培训服务咨询有限公司|浙江省机电集团有限公司|浙江省二轻集团有限责任公司|巨化集团上海融资租赁有限公司|浙江巨化股份有限公司|宁波航运交易所有限公司|浙江巨化投资有限公司|浙江省农村发展集团有限公司|浙江省国际贸易集团温州有限公司|浙江巨化化工矿业有限公司|浙江天虹物资贸易有限公司|浙江浙能兴源节能科技有限公司|浙江巨化装备工程集团有限公司|温州瑞平苍高速公路有限公司|上海巨化实业发展有限公司|浙能集团新疆准东煤业有限公司|浙江浙能煤运投资有限责任公司|浙江省新能源投资集团股份有限公司|浙江锦华新材料股份有限公司|浙旅湛景置业有限公司|浙江省交通投资集团财务有限责任公司|杭州钢铁集团有限公司|浙江巨化塑胶有限责任公司|浙江巨化信息技术有限公司|浙江新农都实业有限公司|浙江省万里教育集团|浙江长广（集团）有限责任公司|浙江海港资产管理有限公司|物产中大融资租赁集团有限公司|浙江浙能企业管理培训服务有限公司|浙江省海洋产业投资有限公司|浙江省交通投资集团有限公司|浙江轻工联非融资性担保有限公司|浙江省机场集团有限公司|浙江巨化汉正新材料有限公司|浙江海港内河港口发展有限公司|浙江外事旅游股份有限公司|浙江省浙商资产管理股份有限公司|浙江东方金融控股集团股份有限公司|浙江浙能技术研究院有限公司|浙江经济职业技术学院|浙江巨化清安检测科技有限公司|浙江省国有资本运营有限公司|浙江省土产畜产进出口集团有限公司|浙江巨化能源有限公司|浙江产权交易所有限公司|宁波海运集团有限公司|浙江省中国旅行社集团有限公司|杭州工商信托股份有限公司|浙江省衢州机场管理有限公司|浙江省旅游投资集团有限公司|巨化集团公司塑化厂|同煤浙能麻家梁煤业有限责任公司|浙江轻工联典当有限责任公司|浙江省海港投资运营集团有限公司|衢州衢化宾馆有限公司|舟山普陀山机场有限公司|深圳市巨化华南投资发展有限公司|浙江金华安邦护卫有限公司|浙江海港洋山投资开发有限公司|物产中大资本管理（浙江）有限公司|浙江南方工程咨询管理有限公司|黑龙江绿色农业发展集团有限公司|浙商财产保险股份有限公司|物产中大资产管理（浙江）有限公司|衢州氟硅技术研究院|招商局港口集团股份有限公司|浙江省台州机场管理有限公司|浙江省机电技师学院|巨化集团财务有限责任公司|浙江省电力建设有限公司|浙江省中医药健康产业集团有限公司|浙江巨化化工材料有限公司|浙江浙商金控有限公司|浙江富兴电力燃料有限公司|浙旅蝶来酒店集团有限公司|浙江英特集团股份有限公司|浙江省义乌机场管理有限公司|浙江省农都农产品有限公司|物产中大集团财务有限公司|宁波海运股份有限公司|浙江省建设投资集团股份有限公司|浙江菲达环保科技股份有限公司|浙江海正药业股份有限公司|物产中大集团股份有限公司|浙江运达风电股份有限公司|杭州钢铁股份有限公司|浙商中拓集团股份有限公司|勿忘农集团有限公司|浙江交通科技股份有限公司|巨化集团（香港）有限公司|香港泰纬国际贸易有限公司|浙江能源国际有限公司|常熟市国瑞科技股份有限公司|浙江镇洋发展股份有限公司|浙商银行股份有限公司|浙江物产环保能源股份有限公司|浙江诺和机电股份有限公司|浙江沪杭甬高速公路股份有限公司|宁波远洋运输股份有限公司|浙江大学控股集团有限公司|安邦护卫集团股份有限公司|浙江富建投资管理有限公司|浙江富浙科技有限公司|浙江富浙资产管理有限公司|浙江富浙资本管理有限公司|浙江富物资产管理有限公司|浙江省发展资产经营有限公司|浙江省环境科技有限公司|浙江省盐业集团有限公司|浙江省种业集团有限公司|浙江物产中大医药有限公司|浙江物产元通汽车集团有限公司|浙江物产实业控股（集团）有限公司|物产中大（浙江）产业投资有限公司|物产中大云商有限公司|物产中大元通实业集团有限公司|物产中大元通汽车有限公司|物产中大公用环境投资有限公司|物产中大化工集团有限公司|物产中大医疗健康投资有限公司|物产中大国际学院|物产中大数字科技有限公司|物产中大欧泰有限公司|物产中大物流投资集团有限公司|物产中大财智共享服务（浙江）有限公司|物产中大金属集团有限公司|物产中大金石集团有限公司|物产中大长乐林场有限公司|物产中大集团投资有限公司|南水北调（开化）水务有限公司|太仓中茵建设投资有限公司|安吉浙建投资有限公司|庆元县浙建项目管理有限公司|新昌县浙建投资管理有限公司|新疆阿拉尔上游水利水电工程有限责任公司|杭州财金未来社区股权投资合伙企业（有限合伙）|永嘉县浙建投资有限公司|浙建（兰溪）矿业有限公司|浙建项目管理（杭州）有限公司|浙江基建投资管理有限公司|浙江天台浙建环保科技有限公司|浙江建工建筑工程咨询有限公司|浙江建投创新科技有限公司|浙江建投发展房地产开发有限公司|浙江建投工程物资设备有限公司|浙江建投数字技术有限公司|浙江建投机械租赁有限公司|浙江建投环保工程有限公司|浙江建设商贸物流有限公司|浙江浙建云采贸易有限公司|浙江浙建实业发展有限公司|浙江浙建建筑设计有限公司|浙江浙建美丽乡村建设有限公司|浙江浙建钢结构有限公司|浙江省一建建设集团有限公司|浙江省二建建设集团有限公司|浙江省工业设备安装集团有限公司|浙江省建工集团有限责任公司|浙江省建投交通基础建设集团有限公司|浙江省建材集团有限公司|浙江省建设工程机械集团有限公司|浙江财金未来社区股权投资有限责任公司|衢州市衢江区浙建投资管理有限公司|长兴建图建设投资管理有限公司|长兴浙建投资有限公司|玉环市浙建城镇建设投资有限公司|绍兴市越城区浙建建设项目管理有限公司|绍兴市越城区浙建投资有限公司|苏州浙建地产发展有限公司|长兴浙建城镇建设有限公司|遂昌浙建投资有限公司|长兴浙永建设投资有限公司|阿拉尔浙建城市建设投资有限公司|浙江《机电工程》杂志社有限公司|浙江工匠培训有限公司|浙江康宁咨询服务有限公司|浙江新华体育器材制造有限公司|浙江机电华瑞航空投资有限公司|浙江机电集团投资有限公司|浙江新联民爆器材有限公司|浙江浙商金融服务有限公司|浙江省军工集团股份有限公司|浙江省工业矿产对外贸易有限责任公司|浙江省机电设计研究院有限公司|浙江蓝箭称重技术有限公司|浙江省机械设备进出口有限责任公司|浙江富浙投资有限公司|浙江海正集团有限公司|浙江五金矿产控股有限公司|浙江省医药保健品进出口有限责任公司|浙江省国兴进出口有限公司|浙江省国际贸易集团供应链有限公司|浙江省工艺品进出口有限公司|浙江经贸房地产公司|浙江英特药业有限责任公司|天台国大镕丰酒店管理有限公司|杭州千岛湖温馨岛娱乐旅游有限公司|杭州花港饭店|浙江《江南游报》社有限责任公司|浙江东菱酒店有限公司|杭州花港海航度假酒店有限公司|浙江国际大酒店有限公司|浙江旅游信息中心有限公司|浙江时代国际展览服务有限公司|浙江浙勤服务控股集团有限公司|浙江浙勤集团有限公司|浙江浙旅投数字科技有限公司|浙江省人才发展集团有限公司|浙江省古村落（传统村落）保护利用股权投资基金合伙企业（有限合伙）|浙江省国际投资服务中心有限公司|浙江省国际贸易展览有限公司|浙江省旅工贸有限责任公司|浙江雷迪森物业服务有限公司|浙江雷迪森酒店集团有限公司|舟山市普陀山银海饭店有限公司|雷迪森旅业集团有限公司|上海杭钢凯暄矿业投资有限公司|幸福之江资本运营有限公司|杭州杭钢合金钢铸造有限公司|杭州钢铁厂小型轧钢股份有限公司|浙江东菱商贸有限公司|浙江富春紫光环保股份有限公司|中杭监测技术研究院有限公司|杭州紫云能源综合利用开发有限公司|杭州紫元置业有限公司|浙江杭钢人力资源开发服务有限公司|浙江杭钢健康产业投资管理有限公司|浙江杭钢公管后勤服务有限公司|浙江杭钢动力有限公司|浙江杭钢商贸集团有限公司|浙江杭钢工贸有限公司|浙江杭钢数字科技有限公司|浙江杭钢智谷科技有限公司|浙江杭钢电炉炼钢有限公司|浙江杭钢职业教育集团有限公司|浙江杭钢高速线材有限公司|浙江省冶金研究院有限公司|浙江省工业设计研究院有限公司|浙江省环保集团有限公司|浙江省遂昌金矿有限公司|浙江紫汇资产管理有限公司|浙江紫臻物业管理服务有限公司|浙江钢联控股有限公司|温州杭钢水务有限公司|上海华山康健医疗有限公司|台州台信企业管理合伙企业（有限合伙）|浙江中天东方氟硅材料股份有限公司|浙江巨化环保科技有限公司|浙江巨柯私募基金管理有限公司|浙江巨荣石油化工销售有限公司|浙江晋巨化工有限公司|浙能巨化（浙江自贸区）股权投资基金合伙企业（有限合伙）|中核浙能能源有限公司|中海油绿能港浙江宁波能源有限公司|伊犁新矿煤业有限责任公司|内蒙古同煤鄂尔多斯矿业投资有限公司|国家管网集团浙江省天然气管网有限公司|浙江浙能产业研究院有限公司|浙江浙能物业发展有限公司|浙江浙能绿城体育文化发展有限公司|浙江省白马湖实验室有限公司|浙江职业足球俱乐部有限公司|嘉兴公路建设投资有限公司|嘉兴市嘉萧高速公路投资开发有限公司|德清县杭绕高速有限公司|杭州都市高速公路有限公司|浙商食品集团有限公司|浙江临金高速公路有限公司|浙江义东高速公路有限公司|浙江乐清湾高速公路有限公司|浙江交投交通建设管理有限公司|浙江交投太平交通基础设施股权投资基金（有限合伙）|浙江交投高速公路建设管理有限公司|浙江交投高速公路运营管理有限公司|浙江交通资源投资集团有限公司|浙江台州沈海高速公路有限公司|浙江台州甬台温高速公路有限公司|浙江宁波杭甬复线三期高速公路有限公司|浙江宁波甬台温高速公路有限公司|浙江数智交院科技股份有限公司|浙江景文高速公路有限公司|浙江杭宁高速公路有限责任公司|浙江杭宣高速公路有限公司|浙江杭新景高速公路有限公司|浙江杭海城际铁路有限公司|浙江杭温铁路有限公司|浙江杭甬复线宁波一期高速公路有限公司|浙江杭绍甬高速公路有限公司|浙江沪平盐铁路有限公司|浙江温州市域铁路一号线有限公司|浙江甬舟复线一期高速公路有限公司|浙江省交投控股集团有限公司|浙江省交通投资集团高速公路管理有限公司|浙江省商业集团有限公司|浙江省海运集团股份有限公司|浙江省经济建设投资有限公司|浙江省轨道交通建设管理集团有限公司|浙江省轨道交通运营管理集团有限公司|浙江省铁路发展控股集团有限责任公司|浙江省长三角投资有限公司|浙江舟山北向大通道有限公司|浙江衢丽铁路有限公司|浙江衢松铁路有限公司|浙江诸永高速公路有限公司|浙江路产城发展集团有限公司|浙江金华甬金衢上高速公路有限公司|浙江高信技术股份有限公司|浙江高速物流有限公司|温州市文泰高速公路有限公司|温州市瑞文高速公路有限公司|绍兴柯桥杭金衢联络线高速公路有限公司|金华市东永高速投资有限公司|东港投资发展集团有限公司|杭州农发原乡人农特产有限公司|杭州千岛湖鲟龙科技股份有限公司|浙江农发产业投资有限公司|浙江省现代农业研究会|芜湖信农硬科技投资合伙企业（有限合伙）|黑龙江亚欧牧业有限公司|浙江四港联动发展有限公司|浙江电子口岸有限公司|浙江空港商业经营管理有限责任公司|浙江空港数字科技有限公司|浙江空港资本控股有限公司|上海大宗商品仓单登记有限责任公司|宁波舟山港铁矿石储运有限公司|杭州港务集团有限公司|浙江中澳现代产业园有限公司|浙江义迪通供应链服务有限公司|浙江之迪控股有限公司|浙江海港国际联运有限公司|浙江海港大宗商品交易中心有限公司|浙江海港引航服务有限公司|浙江船舶交易市场有限公司|杭州富格企业管理合伙企业（有限合伙）|杭州松下马达有限公司|汇孚集团有限公司|浙江信联钢铁有限公司|浙江广杰投资管理有限公司|浙江建设融资租赁有限公司|浙江杰尚投资管理有限公司|浙江申达塑料机械有限公司|浙江申达机器制造股份有限公司|浙江省二轻供销总公司|浙江省二轻商业经营管理有限公司|浙江省二轻房地产开发有限公司|浙江省工美控股有限公司|浙江省工艺美术研究院有限公司|浙江省皮革塑料有限公司|浙江省艺创投资发展股份有限公司|浙江省艺创文旅发展有限公司|安邦护卫（浙江）公共安全智慧科技有限公司|浙江丽水安邦护卫有限公司|浙江台州安邦护卫有限公司|浙江嘉兴安邦护卫有限公司|浙江宁波安邦护卫有限公司|浙江安邦护卫安全服务有限公司|浙江安邦护卫科技服务有限公司|浙江杭州安邦护卫有限公司|浙江温州安邦护卫有限公司|浙江湖州安邦护卫有限公司|浙江绍兴安邦护卫有限公司|浙江舟山安邦护卫有限公司|浙江衢州安邦护卫有限公司|上海浙大科技发展有限公司|杭州启真未来创新股权投资合伙企业（有限合伙）|杭州浙大动物医院有限公司|杭州浙大文化创意发展有限公司|杭州紫金港未来创新投资合伙企业（有限合伙）|杭州网新信息控股有限公司|杭州西投启真脑机智能产业运营有限公司|浙江启真人才发展有限公司|浙江大学农业科技园有限公司|浙江大学创新技术研究院有限公司|浙江大学城乡规划设计研究院有限公司|浙江大学杭州国际科创中心发展有限公司|浙江大学科技园发展有限公司|浙江大学能源工程设计研究院有限公司|浙江浙大列车智能化工程技术研究中心有限公司|浙江浙大圆正科技创新服务有限公司|浙江浙大新宇物业集团有限公司|浙江浙大科创集团有限公司|浙江浙大西投脑机智能科技有限公司|浙江钱塘机器人及智能装备研究有限公司|丽水市廉合产权交易有限公司|北京中产智合咨询服务中心（有限合伙）|北京金马甲产权网络交易有限公司|台州市产权交易所有限公司|嘉兴市产权交易有限公司|湖州市联合产权交易有限公司|绍兴市产权交易有限公司|舟山市产权交易中心有限责任公司|衢州市产权交易中心有限公司|浙江省三建建设集团有限公司|'
        kwL=kwLstr.split('|')
        for kk in kwL:
            kwmsg={
                'kw':kk,
                'wordsCode':'qqnews',
                'sid':'102003'
            }
            kwList.append(kwmsg)
        return kwList
    def runLocSpider(self,kwmsg):
        searchkw=kwmsg['kw']
        wordsCode=kwmsg['wordsCode']
        sid=kwmsg['sid']
        jrttnewsSpider=QQnewsSpider(searchkw,wordsCode,sid)
        try:
            jrttnewsSpider.get_page_html()
        except Exception as e:
            logger.info('今日头条搜索异常'+searchkw)

        if jrttnewsSpider.detailList.qsize() != 0:
            try:
                jrttnewsSpider.get_detail_html()
            except Exception as e:
                logger.info('详情解析异常'+searchkw)
        logger.info("关键词采集结束！"+searchkw)
if __name__ == '__main__':
    qqnewsTaskJob=QQnewsTaskJob()
    baseCore=BaseCore()
    logger=baseCore.getLogger()
    # ss='(中国机床工具工业协会|中国内燃机工业协会|中国机电工业价格协会|中国机械电子兵器船舶工业档案学会|中国仪器仪表行业协会|中国工程机械工业协会|中国文化办公设备制造行业协会|中国机械工业金属切削刀具技术协会|中国机械工业教育协会|中国汽车工业协会|中国机械通用零部件工业协会|中国环保机械行业协会|中国模具工业协会|中国机械工业勘察设计协会|中国机械制造工艺协会|中国机械工业审计学会|中国轴承工业协会|中国机电一体化技术应用协会|中国机械工程学会|中国液压气动密封件工业协会|中国铸造协会|中国通用机械工业协会|中国锻压协会|中国制冷空调工业协会|中国热处理行业协会|中国电工技术学会|中国仪器仪表学会|中国石油和石油化工设备工业协会|中国表面工程协会|中国食品和包装机械工业协会|中国焊接协会|中国汽车工程学会|中国塑料机械工业协会|中国机械工业企业管理协会|中国印刷及设备器材工业协会|中国机械工业质量管理协会|中国电器工业协会|中国机械工业安全卫生协会|中国重型机械工业协会|中国机械工业标准化技术协会|中国机械工业职工思想政治工作研究会|中国农业机械工业协会|中国机电装备维修与改造技术协会 |机械工业信息研究院|机械工业教育发展中心|机械工业经济管理研究院|机械工业信息中心|机械工业人才开发服务中心|机械工业北京电工技术经济研究所|机械工业技术发展基金会|机械工业哈尔滨焊接技术培训中心|机械工业仪器仪表综合技术经济研究所)+(私收会费|私吞|肆意牟利|损失浪费|索贿|贪财|贪官污吏|贪污|违背组织原则|违法|违纪|为官不廉|为政擅权|窝案|舞弊|泄露国家机密|信鬼神|性关系|虚假信息|虚假招标|隐瞒不报|隐瞒真相|营私|鬻爵|主动投案|资产流失|钻空子|钻漏洞|被调查|被双开|不担当|不老实|不良影响|不正当|不作为|超标准建设|超标准装修|吃空饷|吃拿卡要|渎职|对党不忠诚|非法批地|腐败|腐虫|腐化堕落|公车私用|公费开销|公款吃喝|公款出境|公款旅游|勾结|官迷心窍|好色|回扣|贿赂|挤占挪用|纪律审查|监察调查|监守自盗|践踏法律|接受审查调查|截留克扣|开除党籍|开除公职|抗议|利欲熏心|敛财|乱摊派|乱作为|落马|落网|买官|买卖审批权限|卖官|谋取暴利|谋取私利|目无法纪|幕后交易|弄虚作假|挪用公款|骗取|钱色交易|潜规则|侵害权益|侵吞公款|侵占挪用|圈子文化|权利扭曲|权钱交易|权色交易|山头主义|涉案|生活糜烂|生活奢靡|失察|失管|收送|受贿|双规|双开|私分|私人会所|私设小金库|负面|下降|违规|不利|亏损|上诉|不法|不良名单|停职|公开谴责|公诉|内幕交易|刑事拘留|刑事责任|刑拘|判决|判刑|判赔|司法处置|合同纠纷|处分|处罚|强制执行|仲裁|伪造|伪造公章|投案|投诉|拘留|接受调查|控诉|查封|涉嫌|涉诉监察调查|纠纷|经营异常名录|缉捕|罚单|罚款|罚金|罪犯|自首|获刑|行贿|警示函|贪腐|违约金|追究刑责|造假|逮捕|非法|非法集资判决书|申诉|纠纷|通报|开除|留党察看|追债|逃债|资产负债率|情色交易|搞权钱|曝光|黑料|重罚|虚假报告|侵犯)'
    # keymsglist=baiduTaskJob.getkeywords(ss)
    # print(keymsglist)
    # 创建Redis连接

    print('---------------')
    while True:
        try:
            codeList=[]
            codeList.append('KW-20231013-0001')
            for codeid in codeList:
                try:
                    # keymsg=qqnewsTaskJob.getkeyFromredis(codeid)
                    # kwList=qqnewsTaskJob.paserKeyMsg(keymsg)
                    kwList=qqnewsTaskJob.lockwMsg()
                    if len(kwList)<1:
                        continue
                    logger.info(f"需要搜索的关键词:{kwList}")
                except Exception as e:
                    logger.info("从kafka拿取信息失败！")
                    time.sleep(5)
                    continue
                if kwList:
                    # 创建一个线程池，指定线程数量为4
                    with concurrent.futures.ThreadPoolExecutor(max_workers=1) as executor:
                        # 提交任务给线程池，每个任务处理一个数据
                        results = [executor.submit(qqnewsTaskJob.runSpider, data) for data in kwList]
                        # 获取任务的执行结果
                        for future in concurrent.futures.as_completed(results):
                            try:
                                result = future.result()
                                # 处理任务的执行结果
                                logger.info(f"任务执行结束: {result}")
                            except Exception as e:
                                # 处理任务执行过程中的异常
                                logger.info(f"任务执行exception: {e}")
        except Exception as e:
            logger.info('采集异常')

