import json
import threading
import time
import uuid
import requests
from retry import retry
from elasticsearch import Elasticsearch
from base import BaseCore
from obs import ObsClient
import fitz
from urllib.parse import unquote
baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()
baseCore = BaseCore.BaseCore()

# 使用连接池
# cnx_ = baseCore.pool_11.connection()
# cursor_ = cnx_.cursor()

cnx_ = baseCore.cnx_
cursor_ = cnx_.cursor()

lock = threading.Lock()
pathType = 'QYNotice/'
taskType = '企业公告/证监会'

class EsMethod(object):

    def __init__(self):
        # 创建Elasticsearch对象，并提供账号信息
        self.es = Elasticsearch(['http://114.116.19.92:9700'], http_auth=('elastic', 'zzsn9988'), timeout=300)
        self.index_name = 'researchreportdata'

    def queryatt(self,index_name,pnum):
       body = {
           "_source": ["attachmentIds",  "sourceAddress",  "title",
                       "publishDate", "createDate"],
           "query": {
               "bool": {
                   "must": [
                       {
                           "match": {
                               "type": "0"
                           }
                       }
                   ]
               }
           },
           "sort": [
               {
                   "createDate": {
                       "order": "asc"
                   }
               }
           ],
           "track_total_hits": True,
           "size": 200,
           "from": pnum
       }

       filter_path = ['hits.hits._id',
                      'hits.total.value',
                      'hits.hits._source.attachmentIds',  # 字段1
                      'hits.hits._source.title',
                      'hits.hits._source.sourceAddress',
                      'hits.hits._source.createDate',
                      'hits.hits._source.publishDate',
                      ]  # 字段2
       result = self.es.search(index=index_name
                               , doc_type='_doc'
                               , filter_path=filter_path
                               , body=body)
       # log.info(result)
       return result

    def updateaunn(self,index_name,id,u_attid):
        body = {
            'doc': {
                'attachmentIds': [str(u_attid)]
            }
        }
        result = self.es.update(index=index_name
                                ,id=id
                                ,body=body)
        log.info('更新结果:%s' % result)

# 根据es附件id，去附件表中查询，未查询到的研报，根据title查询出附件id，更新es

def secrchATT(item_id, retData, type_id,order_by):

    sel_sql = '''select id from clb_sys_attachment where item_id = %s and path = %s and type_id=%s and order_by=%s '''
    lock.acquire()
    cursor_.execute(sel_sql, (item_id, retData['path'], type_id,order_by))
    selects = cursor_.fetchone()
    lock.release()
    return selects

if __name__ == "__main__":
    esMethod = EsMethod()
    p = 200
    result = esMethod.queryatt(index_name=esMethod.index_name, pnum=p)
    total = result['hits']['total']['value']
    page = 0
    if total == 0:
        log.info('++++已没有数据+++++')

    msglist = result['hits']['hits']
    print(msglist)
    log.info(f'---第{page}页{len(msglist)}条数据----共{total}条数据----')
    num = 0
    for mms in msglist:
        start_time = time.time()
        id = mms['_id']
        title = mms['_source']['title']
        sourceAddress = mms['_source']['sourceAddress']
        social_code = mms['_source']['labels'][0]['relationId']
        year = mms['_source']['year']
        publishDate = mms['_source']['publishDate']
        createDate = mms['_source']['createDate']
        log.info(f'{id}---{title}--{sourceAddress}---{social_code}')
