# 十大控股股东
from datetime import datetime

import pandas as pd
import requests

headers = {
        'Accept': '*/*',
        'Accept-Encoding': 'gzip, deflate, br',
        'Accept-Language': 'zh-CN,zh;q=0.9',
        'Connection': 'keep-alive',
        'Host': 'datacenter.eastmoney.com',
        'Origin': 'https://emweb.securities.eastmoney.com',
        'Referer': 'https://emweb.securities.eastmoney.com/',
        'Sec-Fetch-Dest': 'empty',
        'Sec-Fetch-Mode': 'cors',
        'Sec-Fetch-Site': 'same-site',
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36',
        'sec-ch-ua': '"Google Chrome";v="119", "Chromium";v="119", "Not?A_Brand";v="24"',
        'sec-ch-ua-mobile': '?0',
        'sec-ch-ua-platform': '"Windows"'
    }

def getData(url):
    request = requests.get(url=url, headers=headers)
    json_data_1 = request.json()
    return json_data_1
def getReportTime():

    list_date = []
    # 获取当前日期和时间
    current_date_ = datetime.now()

    year = int(current_date_.strftime('%Y'))
    list_month = ['-12-31', '-09-30', '-06-30', '-03-31']
    for year in range(year, 2017, -1):
        for month in list_month:
            date = str(year) + month
            #todo:判断拼接的报告期是否大于当前日期，如果大于当前日期，怎说明还没到这个时间，跳过
            current_date = current_date_.strftime('%Y-%m-%d')
            if current_date < date:
                continue
            list_date.append(date)
    return list_date

if __name__=="__main__":
    df_1 = pd.read_excel('./需要补全的数据.xlsx', dtype=str)
    for j in range(len(df_1)):
        data = df_1['控股股东'][j]
        if data != 'None':
            # print(data)
            continue
        code = df_1['A股代码'][j]
        code1 = str(code)
        while True:
            if len(code1)<6:
                code1 = '0'+code1
            else:
                break
        if code1[0] == '0' or code1[0] == '3':
            com_code = 'SZ'+code1
        elif code1[0] == '6':
            com_code = 'SH'+code1
        elif code1[0] == '8' or code1[0] == '4':
            com_code = 'BJ'+code1
        holders = []
        top_holders = []

        time_list = getReportTime()
        for time in time_list:
            #         https://datacenter.eastmoney.com/securities/api/data/v1/get?reportName=RPT_F10_EH_HOLDERS&columns=SECUCODE%2CSECURITY_CODE%2CEND_DATE%2CHOLDER_RANK%2CHOLDER_NAME%2CSHARES_TYPE%2CHOLD_NUM%2CHOLD_NUM_RATIO%2CHOLD_NUM_CHANGE%2CCHANGE_RATIO&quoteColumns=&filter=(SECUCODE%3D%22002604.SZ%22)(END_DATE%3D%272023-06-30%27)&pageNumber=1&pageSize=&sortTypes=1&sortColumns=HOLDER_RANK&source=HSF10&client=PC&v=09727151187367775
            url_1 = f'https://datacenter.eastmoney.com/securities/api/data/v1/get?reportName=RPT_F10_EH_HOLDERS&columns=SECUCODE%2CSECURITY_CODE%2CEND_DATE%2CHOLDER_RANK%2CHOLDER_NAME%2CSHARES_TYPE%2CHOLD_NUM%2CHOLD_NUM_RATIO%2CHOLD_NUM_CHANGE%2CCHANGE_RATIO&quoteColumns=&filter=(SECUCODE%3D%22{code1}.{com_code[:2]}%22)(END_DATE%3D%27{time}%27)&pageNumber=1&pageSize=&sortTypes=1&sortColumns=HOLDER_RANK&source=HSF10&client=PC&v=09613150754547122'

            json_data_1 = getData(url_1)
            try:
                top_holders = json_data_1['result']['data']
            except:
                continue
            if top_holders:
                for holder in top_holders:
                    holder_name_1 = holder['HOLDER_NAME']
                    holde_ratio_1 = holder['HOLD_NUM_RATIO']
                    holders.append(f'{holder_name_1}({holde_ratio_1}%)')
                print(holders)
                result = ','.join(holders)
                print(result)
                df_1['控股股东'][j] = str(result)
                df_1.to_excel('./需要补全的数据.xlsx', index=False)
            break
