"""
从es中拿到所有的标题
"""
import redis
from elasticsearch import Elasticsearch
from base import BaseCore

baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()

class EsMethod(object):

    def __init__(self):
        # 创建Elasticsearch对象，并提供账号信息
        self.es = Elasticsearch(['http://114.116.19.92:9700'], http_auth=('elastic', 'zzsn9988'), timeout=300)
        self.index_name = 'researchreportdata'

    def queryatt(self,index_name):
       body = {
           "query": {
               "bool": {
                   "must": [
                       {
                           "nested": {
                               "path": "labels",
                               "query": {
                                   "match": {
                                       "labels.relationId": "91330000747735638J"
                                   }
                               }
                           }
                       },
                       {
                           "range": {
                               "createDate": {
                                   "gte": "2024-02-26T13:00:00",
                                   "lte": "2024-02-27T00:00:00"
                               }
                           }
                       },
                       {
                           "term": {
                               "type.keyword": {
                                   "value": "3"
                               }
                           }
                       }
                   ]
               }
           },
           "sort": [
               {
                   "createDate": {
                       "order": "desc"
                   }
               }
           ],
           "track_total_hits": True,
           "size": 100
       }

       filter_path = ['hits.hits._id',
                      'hits.total.value',
                      'hits.hits._source.title',
                      'hits.hits._source.origin',
                      'hits.hits._source.publishDate',
                      ]  # 字段2
       result = self.es.search(index=index_name
                               , doc_type='_doc'
                               , filter_path=filter_path
                               , body=body)
       # log.info(result)
       return result



if __name__ == '__main__':
    es_method = EsMethod()
    # 连接Redis
    r = redis.Redis(host="114.115.236.206", port=6379, password='clbzzsn', db=6)

    result = es_method.queryatt('researchreportdata')
    total = result['hits']['total']['value']
    try:
        msglist = result['hits']['hits']
    except:
       log.info(f'error-----{result}')

    log.info(f'---第1页{len(msglist)}条数据----共{total}条数据----')

    for mms in msglist:
       id = mms['_id']
       title = mms['_source']['title']
       origin = mms['_source']['origin']
       pub_time = mms['_source']['publishDate']
       try:
           log.info(f'{id}--{title}--{origin}--')
           item = id + "|" + title
           # r.lrem(f'XJPdatabase:id_2', 0, item)
           r.lpush(f'91330000747735638J:id', item)
       except:
           continue
