import json
import threading
import time
import uuid

import redis
import requests
from retry import retry
from elasticsearch import Elasticsearch
from base import BaseCore
from obs import ObsClient
import fitz
from urllib.parse import unquote
baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()
baseCore = BaseCore.BaseCore()

# 使用连接池
# cnx_ = baseCore.pool_11.connection()
# cursor_ = cnx_.cursor()

cnx_ = baseCore.cnx_
cursor_ = cnx_.cursor()

lock = threading.Lock()
pathType = 'QYNotice/'
taskType = '企业研报/东方财富网'

pool = redis.ConnectionPool(host="114.115.236.206", port=6379, password='clbzzsn', db=6)

class EsMethod(object):

    def __init__(self):
        # 创建Elasticsearch对象，并提供账号信息
        self.es = Elasticsearch(['http://114.116.19.92:9700'], http_auth=('elastic', 'zzsn9988'), timeout=300)
        self.index_name = 'researchreportdata'

    def queryatt(self, index_name, xydm, year, att_id):
        body = {
            "query": {
                "bool": {
                    "must": [
                        {
                            "nested": {
                                "path": "labels",
                                "query": {
                                    "match": {
                                        "labels.relationId": f"{xydm}"
                                    }
                                }
                            }
                        },
                        {
                            "term": {
                                "type.keyword": {
                                    "value": "1"
                                }
                            }
                        },
                        {
                            "term": {
                                "attachmentIds.keyword": att_id
                            }
                        },
                        {
                            "term": {
                                "year.keyword": {
                                    "value": f"{year}"
                                }
                            }
                        }
                    ]
                }
            },
            "sort": [
                {
                    "publishDate": {
                        "order": "desc"
                    }
                }
            ],
            "track_total_hits": True,
            "size": 10
        }
        filter_path = ['hits.hits._id',
                       'hits.total.value',
                       'hits.hits._source.attachmentIds',  # 字段1
                       'hits.hits._source.title',
                       ]  # 字段2
        result = self.es.search(index=index_name
                                , doc_type='_doc'
                                , filter_path=filter_path
                                , body=body)
        return result

def main(esMethod):
    redis_conn = redis.Redis(connection_pool=pool)
    info_ = redis_conn.lpop("NianBao:info")
    if info_:
        pass
    else:
        log.info("++++已没有数据++++")

        return
    info = info_.decode()
    xydm = info.split('|')[0]
    att_id = info.split('|')[1]
    year = info.split('|')[2]
    res = esMethod.queryatt(esMethod.index_name, xydm, year, att_id)
    total = res['hits']['total']['value']
    if total == 0:
        log.error(f'{xydm}==={year}==={att_id}==未查询到')
        redis_conn.lpush('NianBao:id', info)
        return

def run_threads(num_threads,esMethod):
    threads = []

    for i in range(num_threads):

        thread = threading.Thread(target=main, args=(esMethod,))

        threads.append(thread)
        thread.start()

    for thread in threads:
        thread.join()



if __name__ == "__main__":
    while True:
        esMethod = EsMethod()
        start = time.time()
        num_threads = 5
        run_threads(num_threads, esMethod)

        log.info(f'5线程  总耗时{time.time() - start}秒')
