import json
import time

import pandas as pd
import requests
import urllib3
from bs4 import BeautifulSoup
# sys.path.append(r'F:\zzsn\zzsn_spider\base')
# import BaseCore
from retry import retry

from base import BaseCore

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

taskType = '企业基本信息/雅虎财经'

baseCore = BaseCore.BaseCore()
r = baseCore.r
log = baseCore.getLogger()
headers = {
    'accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.9',
    'accept-encoding': 'gzip, deflate, br',
    'accept-language': 'zh-CN,zh;q=0.9,en-US;q=0.8,en;q=0.7',
    'cache-control': 'max-age=0',
    'sec-ch-ua': '"Chromium";v="106", "Google Chrome";v="106", "Not;A=Brand";v="99"',
    'sec-ch-ua-mobile': '?0',
    'sec-ch-ua-platform': "Windows",
    'sec-fetch-dest': 'document',
    'sec-fetch-mode': 'navigate',
    'sec-fetch-site': 'same-origin',
    'sec-fetch-user': '?1',
    'upgrade-insecure-requests': '1',
    'user-agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/106.0.0.0 Safari/537.36'
}


@retry(tries=5, delay=3)
def getRes(url):
    response = requests.get(url, headers=headers, verify=False)
    if response.status_code != 200:
        raise
    return response


# 根据股票代码 获取企业基本信息 高管信息
def getInfo(xydm, gpdm, start):
    if 'HK' in str(gpdm):
        tmp_g = str(gpdm).split('.')[0]
        if len(tmp_g) == 5:
            gpdm_ = str(gpdm)[1:]
        else:
            gpdm_ = gpdm
    elif str(gpdm)[-2:] == '.N' or str(gpdm)[-2:] == '.O':
        gpdm_ = gpdm[:-2]
    else:
        gpdm_ = gpdm
    retData = {}
    url = f'https://finance.yahoo.com/quote/{gpdm_}/profile?p={gpdm_}'
    log.info(url)
    time.sleep(3)
    try:
        response = getRes(url)
    except:
        log.error(f"{gpdm}------访问基本信息页面失败")
        state = -1
        exeception = '访问基本信息页面失败'
        takeTime = baseCore.getTimeCost(start, time.time())
        baseCore.recordLog('', taskType, state, takeTime, url, exeception)
        r.lpush('BaseInfoEnterprise:gwqy_socialCode', '')
        return state, retData

    if url != response.url:
        log.error(f'{gpdm}------请求失败')
        state = -1
        # r.lpush('BaseInfoEnterprise:gwqy_socialCode_gg', xydm)
        return state, retData

    state = 1
    soup = BeautifulSoup(response.content, 'html.parser')
    page = soup.find('div', {'id': 'Col1-0-Profile-Proxy'})
    # 高管信息
    retPeople = []
    try:
        list_people = page.find('table', {'class': 'W(100%)'}).find_all('tr')[1:]
    except:
        list_people = []
    for one_people in list_people:
        try:
            p_name = one_people.find_all('td')[0].text
        except:
            p_name = ''
            continue
        try:
            p_zhiwu = one_people.find_all('td')[1].text
        except:
            p_zhiwu = ''
        try:
            p_money = one_people.find_all('td')[2].text
        except:
            p_money = ''
        try:
            p_xingshi = one_people.find_all('td')[3].text
        except:
            p_xingshi = ''
        try:
            p_year = one_people.find_all('td')[4].text
        except:
            p_year = ''

        if (p_zhiwu == "N/A"):
            p_zhiwu = ""
        if (p_money == "N/A"):
            p_money = ""
        if (p_xingshi == "N/A"):
            p_xingshi = ""
        if (p_year == "N/A"):
            p_year = ""
        dic_main_people = {
            '股票代码': gpdm,
            '信用代码': xydm,
            '姓名': p_name,
            '职务': p_zhiwu,
            '薪资': p_money,
            '行使': p_xingshi,
            '出生年份': p_year
        }
        retPeople.append(dic_main_people)
    retData['people_info'] = retPeople
    log.info(f"获取高管信息--{gpdm}，耗时{baseCore.getTimeCost(start, time.time())}")
    response.close()
    return state, retData


@retry(tries=3, delay=2)
def sendPost(json_updata):
    response = requests.post('http://114.115.236.206:9988/datapull/sync/executive', data=json_updata,
                             timeout=300, verify=False)
    if (response.status_code == 200):
        retJson = json.loads(response.content.decode('utf-8'))
        if (retJson['success'] or retJson['success'] == 'true'):
            pass
        else:
            raise
    else:
        raise


# 保存高管信息
def savePeopleInfo(info, xydm, start):
    # 高管信息调用接口
    list_people = info['people_info']
    list_one_info = []
    for i in range(0, len(list_people)):
        dic_json = {
            "socialCreditCode": list_people[i]['信用代码'],
            "name": list_people[i]['姓名'],
            "sex": '',
            "education": '',
            "position": list_people[i]['职务'],
            "salary": list_people[i]['薪资'],
            "birthYear": list_people[i]['出生年份'],
            "shareNum": '',
            "shareRatio": '',
            "benefitShare": '',
            "currentTerm": '',
            "personInfo": '',
            "sort": str(i + 1)
        }
        list_one_info.append(dic_json)
    json_updata = json.dumps(list_one_info)
    if json_updata == '[]':
        log.info("没有高管")
        pass
    else:
        try:
            sendPost(json_updata)
        except:
            log.error(f"保存高管接口失败")
            exception = '保存高管接口失败'
            state = 0
            takeTime = baseCore.getTimeCost(start, time.time())
            baseCore.recordLog(xydm, taskType, state, takeTime, '', exception)
            return state

    state = 1
    log.info(f"保存高管信息--{xydm}，耗时{baseCore.getTimeCost(start, time.time())}")
    return state


# 采集工作
def beginWork():
    while True:
        social_code = baseCore.redicPullData('BaseInfoEnterprise:gwqy_socialCode_gg')
        # social_code = 'ZZSN231114182705007'
        if social_code == 'None' or not social_code:
            time.sleep(20)
            break
        # 数据库中获取基本信息
        data = baseCore.getInfomation(social_code)
        gpdm = data[3]
        xydm = data[2]
        # 获取该企业对应项目的采集次数
        start_time = time.time()
        try:
            state, retData = getInfo(xydm, gpdm, start_time)
            if state == 1:
                state = savePeopleInfo(retData, xydm, start_time)
                time.sleep(1)
                takeTime = baseCore.getTimeCost(start_time, time.time())
                baseCore.recordLog(xydm, taskType, state, takeTime, '', '')
            else:
                pass
        except Exception as e:
            log.error(f'{xydm}===错误原因:{e}')
            pass

    # 释放资源
    baseCore.close()


if __name__ == '__main__':
    beginWork()