import datetime
import time

import pandas as pd
import pymongo
import requests
from apscheduler.schedulers.blocking import BlockingScheduler
from retry import retry
from requests.packages.urllib3 import disable_warnings
import BaseCore
disable_warnings()
baseCore = BaseCore.BaseCore()
log = baseCore.getLogger()
db_storage = pymongo.MongoClient('mongodb://114.115.221.202:27017', username='admin', password='ZZsn@9988').RESCenter[
    'RETIsProdQuot']
db_storage_PO = pymongo.MongoClient('mongodb://114.115.221.202:27017', username='admin', password='ZZsn@9988').RESCenter[
    'REITsProdOverview']
headers = {
    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36 Edg/119.0.0.0'
}

@retry(tries=5, delay=20)
def getCodeList():
    code_list = []
    url = 'https://api.sgx.com/securities/v1.1?excludetypes=bonds&params=nc%2Cadjusted-vwap%2Cbond_accrued_interest%2Cbond_clean_price%2Cbond_dirty_price%2Cbond_date%2Cb%2Cbv%2Cp%2Cc%2Cchange_vs_pc%2Cchange_vs_pc_percentage%2Ccx%2Ccn%2Cdp%2Cdpc%2Cdu%2Ced%2Cfn%2Ch%2Ciiv%2Ciopv%2Clt%2Cl%2Co%2Cp_%2Cpv%2Cptd%2Cs%2Csv%2Ctrading_time%2Cv_%2Cv%2Cvl%2Cvwap%2Cvwap-currency'
    req = requests.get(url, headers=headers, verify=False)
    req.encoding = req.apparent_encoding
    data_json = req.json()['data']['prices']
    for data in data_json:
        if data['type'] == 'reits':
            code = data['nc']
            code_list.append(code)
    req.close()
    return code_list

def getDataJson(code):
    url = f'https://api.sgx.com/securities/v1.1/charts/historic/reits/code/{code}/1w'
    req = requests.get(url,headers=headers,verify=False)
    req.encoding = req.apparent_encoding
    data_json = req.json()['data']['historic']
    req.close()
    return data_json

def doJob():
    code_list = getCodeList()
    for code in code_list:
        data_json = getDataJson(code)
        for data_ in data_json:
            date = datetime.datetime.strptime(data_['trading_time'], '%Y%m%d_%H%M%S')
            country = db_storage_PO.find_one({'code':code,'exchange':'新加坡交易所'})['country']
            is_insert = db_storage.find_one({'code':code,'date':date})
            if is_insert:
                log.info(f'{code}===已采集')
                continue
            name = data_['n']
            opening = data_['o']
            max = data_['h']
            min = data_['l']
            closed = data_['lt']
            ytdClosed = data_['pv']
            volume = float(data_['vl'])*1000
            amount = data_['v']
            dic_info = {
                'code': code,  # 代码
                'shortName': name,  # 简称
                'opening': float(opening),  # 开盘价
                'max': float(max),  # 最高价
                'min': float(min),  # 最低价
                'closed': float(closed),  # 收盘价
                'ytdClosed': float(ytdClosed),  # 前收价
                'volume': float(volume),  # 交易量
                'amount': float(amount),  # 交易金额
                'totalValue': '',  # 市价总值
                'negoValue': '',  # 流通总值
                'toRate': '',  # 换手率
                'date': date,  # 时间
                'strDate': str(date)[:10],
                'country': country,  # 国家
                'exchange': '新加坡交易所',  # 交易所
                'currency':'SGD'# 币种
            }
            try:
                db_storage.insert_one(dic_info)
                log.info(f'{code}==={name}==={date}===采集成功')
            except:
                log.error(f'{code}==={name}==={date}===保存失败')
            time.sleep(2)

def task():
    # 实例化一个调度器
    scheduler = BlockingScheduler()
    # 每天执行一次
    scheduler.add_job(doJob, 'cron', hour='18', minute=0, max_instances=2 )
    try:
        scheduler.start()
    except Exception as e:
        log.error('定时采集异常', e)
        pass



if __name__ == '__main__':
    doJob()
    #task()