import json
import re
import time

import requests
import pandas as pd
import numpy as np
from datetime import datetime, timedelta
from base import BaseCore

baseCore = BaseCore.BaseCore()

headers = {
    'Accept': '*/*',
    'Accept-Encoding': 'gzip, deflate',
    'Accept-Language': 'zh-CN,zh-TW;q=0.9,zh;q=0.8',
    'Cache-Control': 'no-cache',
    'Connection': 'keep-alive',
    'Host': 'query.sse.com.cn',
    'Pragma': 'no-cache',
    'Referer': 'http://www.sse.com.cn/',
    'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/119.0.0.0 Safari/537.36 Edg/119.0.0.0',
}


# 获取json数据
def getJson(url):
    ip = baseCore.get_proxy()
    req = requests.get(url, headers=headers, proxies=ip)
    req.encoding = req.apparent_encoding
    data_json = re.findall('\((.*)\)', req.text)[0]
    data_json = json.loads(data_json)
    return data_json


# 获取总页数
def getTotal():
    url = f'http://query.sse.com.cn/commonQuery.do?jsonCallBack=jsonpCallback51800&isPagination=true&bond_type=4&sqlId=COMMON_SSE_ZCZZQXMLB&pageHelp.pageSize=25&status=&begin=&end=&pageHelp.cacheSize=1&pageHelp.pageNo=1&pageHelp.beginPage=1&_={int(time.time())}'
    data_json = getJson(url)
    total = int(data_json['pageHelp']['pageCount'])
    return total


# 获取基金id列表
def getInfoList(page):
    info_list = []
    url = f'http://query.sse.com.cn/commonQuery.do?jsonCallBack=jsonpCallback51800&isPagination=true&bond_type=4&sqlId=COMMON_SSE_ZCZZQXMLB&pageHelp.pageSize=25&status=&begin=&end=&pageHelp.cacheSize=1&pageHelp.pageNo=1&pageHelp.beginPage={page}&_={int(time.time())}'
    data_json = getJson(url)
    data_json = data_json['result']
    for data in data_json:
        id = data['BOND_NUM']
        type = data['REITS_TYPE']
        if type == '0':
            info_list.append([id,'首次发售'])
        elif type == '1':
            info_list.append([id,'扩募发售'])
        else:
            info_list.append([id,'-'])
    return info_list


# 获取基本信息
def getData(id,type):
    url = f'http://query.sse.com.cn/commonQuery.do?jsonCallBack=jsonpCallback72929&isPagination=false&audit_id={id}&sqlId=COMMON_SSE_ZCZZQXMXXXX&_={time.time()}'
    data_ = getJson(url)['result'][0]
    if data_['AUDIT_STATUS'] == '0':
        audit_status = '已申报'
    elif data_['AUDIT_STATUS'] == '1':
        audit_status = '已受理'
    elif data_['AUDIT_STATUS'] == '2':
        audit_status = '已反馈'
    elif data_['AUDIT_STATUS'] == '3':
        audit_status = '已接收反馈意见'
    elif data_['AUDIT_STATUS'] == '4':
        audit_status = '通过'
    elif data_['AUDIT_STATUS'] == '5':
        audit_status = '未通过'
    elif data_['AUDIT_STATUS'] == '8':
        audit_status = '终止'
    elif data_['AUDIT_STATUS'] == '901':
        audit_status = '承销商/管理人超期中止'
    elif data_['AUDIT_STATUS'] == '9':
        audit_status = '中止'
    elif data_['AUDIT_STATUS'] == '10':
        audit_status = '已回复交易所意见'
    elif data_['AUDIT_STATUS'] == '111':
        audit_status = '提交注册'
    elif data_['AUDIT_STATUS'] == '12':
        audit_status = '注册生效'
    else:
        audit_status = '-'
    if data_['BOND_TYPE'] == '4':
        bond_type = '基础设施公募REITs'
    else:
        bond_type = '其它'
    # data = {
    #     '公募REITs名称': data_['AUDIT_NAME'],
    #     '品种': bond_type,
    #     '发起人': data_['LIST1'],
    #     '管理人': data_['PRIORITY_MANAGER'],
    #     '专项计划名称': data_['PRIORITY_NAME'],
    #     '专项计划管理人': data_['LIST2'],
    #     '无异议函文号': data_['REG_APRV_WEN_HAO'],
    #     '项目状态': audit_status,
    #     '更新日期': data_['PUBLISH_DATE'],
    #     '受理日期': data_['ACCEPT_DATE'],
    # }
    data = [data_['AUDIT_NAME'], bond_type, data_['LIST1'], data_['PRIORITY_MANAGER'],
            data_['PRIORITY_NAME'], data_['LIST2'], data_['REG_APRV_WEN_HAO'], audit_status, data_['PUBLISH_DATE'],
            data_['ACCEPT_DATE'], type]
    return data


def doJob():
    data_list = []
    total = getTotal()
    for page in range(1, total + 1):
        info_list = getInfoList(page)
        for info in info_list:
            id = info[0]
            type = info[1]
            data = getData(id,type)
            data_list.append(data)
            # break
    df = pd.DataFrame(np.array(data_list))
    df.columns = ['公募REITs名称', '品种', '发起人', '管理人', '专项计划名称', '专项计划管理人', '无异议函文号', '项目状态', '更新日期', '受理日期','申报类型']
    df.to_excel('./上海交易所项目动态.xlsx', index=False)


if __name__ == '__main__':
    doJob()
    baseCore.close()
