"""
中国政府采购网
"""
import requests
from bs4 import BeautifulSoup

from selenium import webdriver
from selenium.webdriver.chrome.service import Service
from selenium.webdriver.common.by import By
from selenium.webdriver.common.action_chains import ActionChains
from selenium.webdriver.support.ui import WebDriverWait
from selenium.webdriver.support import expected_conditions as EC

def createDriver():
    chrome_driver = r'D:\cmd100\chromedriver.exe'
    path =  Service(chrome_driver)
    chrome_options = webdriver.ChromeOptions()
    chrome_options.binary_location = r'D:\Google\Chrome\Application\chrome.exe'
    # 设置代理
    # proxy = "127.0.0.1:8080"  # 代理地址和端口
    # chrome_options.add_argument('--proxy-server=http://' + proxy)
    driver = webdriver.Chrome(service=path,chrome_options=chrome_options)
    return driver


def postRrequest(url,headers,com_name):
    payload = {
        'orgName': com_name,
        'enforceUnit': '',
        'punishTime': '',
        'punishTimeMax': '',
        # 'gp': 1
    }
    response = requests.post(url=url,headers=headers,json=payload)
    result = response.text
    return  result

if __name__=="__main__":
    # 模拟浏览器 -- 模拟点击
    headers = {
        'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,image/avif,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3;q=0.7',
        'Accept-Encoding': 'gzip, deflate, br',
        'Accept-Language': 'zh-CN,zh;q=0.9',
        'Cache-Control': 'max-age=0',
        'Connection': 'keep-alive',
        'Content-Length': '183',
        'Content-Type': 'application/x-www-form-urlencoded',
        'Cookie': 'BizAc_cookie=bXBL4nKhXAx0l6BxLapa7EUva6ZNeLWOEUIogHMY9uhekQVTNHyI!79161097!1697785213601; HMF_CI=2b97dd74cf1745069afc2b52a639692c1fe863ae5ec8f5a99fb173dd50c56f387b0f9597470f17b4f940d0828a06c511577ebce9b48edcf05bac7fa2d981b15286; Hm_lvt_9f8bda7a6bb3d1d7a9c7196bfed609b5=1697785203; JSESSIONIDGS6Credit=_6NRWtzkuNQaDVVmVy6sFRKigu7hsSHVYC_QElYDNYDeDpfllLDo!79161097; Hm_lpvt_9f8bda7a6bb3d1d7a9c7196bfed609b5=1697877010',
        'Host': 'www.ccgp.gov.cn',
        'Origin': 'https://www.ccgp.gov.cn',
        'Referer': 'https://www.ccgp.gov.cn/cr/list',
        'Sec-Fetch-Dest': 'iframe',
        'Sec-Fetch-Mode': 'navigate',
        'Sec-Fetch-Site': 'same-origin',
        'Sec-Fetch-User': '?1',
        'Upgrade-Insecure-Requests': '1',
        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/117.0.0.0 Safari/537.36',
        'sec-ch-ua': '"Google Chrome";v="117", "Not;A=Brand";v="8", "Chromium";v="117"',
        'sec-ch-ua-mobile': '?0',
        'sec-ch-ua-platform': '"Windows"'
    }
    com_name = '新疆塔建三五九建工有限责任公司'
    social_code = ''

    # url = 'https://www.ccgp.gov.cn/cr/list'
    url = 'https://www.ccgp.gov.cn/search/cr/'
    browser = createDriver()
    browser.get(url)
    browser.switch_to.frame(browser.find_element(By.TAG_NAME, 'iframe'))
    wait = WebDriverWait(browser, 30)
    wait.until(EC.presence_of_element_located((By.ID, "orgName")))
    browser.find_element(By.ID, 'orgName').send_keys('忠县威华汽车维修厂')
    browser.find_element(By.ID, 'searchForm').click()
    wait = WebDriverWait(browser, 30)
    wait.until(EC.presence_of_element_located((By.TAG_NAME, "body")))
    # 严重违法失信行为
    page_source = browser.page_source
    soup = BeautifulSoup(page_source, 'html.parser')
    table = soup.find('table',id='tableInfo')
    tr_list = table.find_all('tr')
    for info in tr_list[1:]:
        td_list = info.find_all('td')
        number = td_list[0].text
        name = td_list[1].text
        code = td_list[2].text
        address = td_list[3].text
        behavior = td_list[4].text
        punish_result = td_list[5].text
        according_file = td_list[6].text
        punish_date = td_list[7].text
        publish_date = td_list[8].text
        units = td_list[9].text

        dic_info = {
            'number': number,
            'name': name,
            'code': code,
            'address': address,
            'behavior': behavior,
            'punish_result': punish_result,
            'according_file': according_file,
            'punish_date': punish_date,
            'publish_date': publish_date,
            'units': units
        }
