package com.zzsn.clb.web.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.clb.fegin.IServiceProjectClient;
import com.zzsn.clb.web.service.ISubjectService;
import com.zzsn.common.Constants;
import com.zzsn.utils.UDateUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.util.DateUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public class SubjectServiceImpl implements ISubjectService {
    @Resource
    private RestHighLevelClient client;
    @Resource
    IServiceProjectClient serviceProjectClient;

    @Override
    public List<Map<String, Object>> getSubjectCollect(String type, Integer size, Integer subjectType) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = (BoolQueryBuilder) searchSourceBuilder.query();
        if (boolBuilder == null) {
            boolBuilder = QueryBuilders.boolQuery();
        }

        //开始日期
        String queryBgDate = null;
        //结束日期
        String queryEndate = null;
        String timeFiled = "publishDate";
        Date now = new Date();
        //如果是本月
        if (type.equals("month")) {
            queryBgDate = DateUtils.formatDate(new Date(), "yyyy-MM-01");
            queryEndate = DateUtils.formatDate(DateUtils.getTimesMonthNight(), "yyyy-MM-dd");
        }
        //如果是季度
        if (type.equals("quarter")) {
            queryBgDate = DateUtils.formatDate(UDateUtils.getCurrentQuarterStartTime(), "yyyy-MM-01");
            queryEndate = DateUtils.formatDate(UDateUtils.getCurrentQuarterEndTime(), "yyyy-MM-dd");
        }
        //如果是本年
        if (type.equals("year")) {
            queryBgDate = DateUtils.formatDate(new Date(), "yyyy-01-01");
            queryEndate = DateUtils.formatDate(new Date(), "yyyy-12-31");
        }
        if (queryBgDate == null)
            return null;
        boolBuilder.must(QueryBuilders.rangeQuery(timeFiled).gte(queryBgDate));
        boolBuilder.must(QueryBuilders.rangeQuery(timeFiled).lt(queryEndate));


        boolBuilder.must(QueryBuilders.termQuery("checkStatus", 1));// 0 未审核 1 审核 ？
        boolBuilder.must(QueryBuilders.termQuery("deleteFlag", 0));//未删除
        JSONObject jo = new JSONObject();
        jo.put("subjectType", subjectType);
        Result<JSONObject> result = serviceProjectClient.getSubjectList(jo, 1, 200);
        if (!result.isSuccess())
            return null;
        JSONArray jsonArray = result.getResult().getJSONArray("records");
        boolBuilder.must(QueryBuilders.termsQuery("subjectId", jsonArray.stream().map(m -> ((Map) m).get("id")).collect(Collectors.toList())));
        searchSourceBuilder.query(boolBuilder);
        TermsAggregationBuilder aggregation = AggregationBuilders
                //别名
                .terms("num")
                //聚合字段名
                .field("subjectId.keyword")
                //降序
                .order(BucketOrder.count(false))
                //聚合结果数据量，默认只返回前十条
                .size(size);
        searchSourceBuilder.aggregation(aggregation);
        Terms terms = (Terms) getEsList(searchSourceBuilder, "num");
        List<Map<String, Object>> records = new ArrayList<>();
        for (Terms.Bucket buck : terms.getBuckets()) {
            records.add(new HashMap<String, Object>() {
                {
                    put("name", getSubjectName(jsonArray, buck.getKeyAsString()));
                    put("num", buck.getDocCount());
                }
            });
        }

        return records;
    }


    public List<Map<String, Object>> getDaySubjectTrend(String queryBgDate, String queryEndate) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = (BoolQueryBuilder) searchSourceBuilder.query();
        if (boolBuilder == null) {
            boolBuilder = QueryBuilders.boolQuery();
        }

        String today = DateUtils.formatDate(DateUtils.getTimesMonthNight(), "yyyy-MM-dd");
        if (StringUtils.isBlank(queryBgDate)) {
            queryBgDate = today;
        }
        if (StringUtils.isBlank(queryEndate)) {
            queryEndate = today;
        }
        String timeFiled = "publishDate";
        boolBuilder.must(QueryBuilders.rangeQuery(timeFiled).gte(queryBgDate));
        boolBuilder.must(QueryBuilders.rangeQuery(timeFiled).lte(queryEndate));


        boolBuilder.must(QueryBuilders.termQuery("checkStatus", 1));// 0 未审核 1 审核 ？
        boolBuilder.must(QueryBuilders.termQuery("deleteFlag", 0));//未删除
        JSONObject jo = new JSONObject();
        jo.put("subjectType", 1);
        Result<JSONObject> result = serviceProjectClient.getSubjectList(jo, 1, 200);
        if (!result.isSuccess())
            return null;
        JSONArray jsonArray = result.getResult().getJSONArray("records");
        boolBuilder.must(QueryBuilders.termsQuery(
                "subjectId", jsonArray.stream().map(m -> ((Map) m).get("id")).collect(Collectors.toList())));
        searchSourceBuilder.query(boolBuilder);

        DateHistogramAggregationBuilder aggregation = AggregationBuilders
                .dateHistogram("publishDate")
                .field("publishDate")
                .format("yyyy-MM-dd")
                .fixedInterval(DateHistogramInterval.DAY);
        aggregation.subAggregation(AggregationBuilders
                //别名
                .terms("num")
                //聚合字段名
                .field("subjectId.keyword")
                //降序
                .order(BucketOrder.count(false))
                //聚合结果数据量，默认只返回前十条
                .size(100));

        searchSourceBuilder.aggregation(aggregation);
        Histogram terms = (Histogram) getEsList(searchSourceBuilder, "publishDate");
        List<Map<String, Object>> records = new ArrayList<>();
        for (Histogram.Bucket buckDate : terms.getBuckets()) {
            Terms byAgeAggregation = buckDate.getAggregations().get("num");
            for (Terms.Bucket buck : byAgeAggregation.getBuckets()) {
                records.add(new HashMap<String, Object>() {
                    {
                        put("name", getSubjectName(jsonArray, buck.getKeyAsString()));
                        put("date", buckDate.getKeyAsString());
                        put("num", buck.getDocCount());
                    }
                });
            }
        }

        return records;
    }


    /***
     * 执行专题信息查询操作
     * @param searchSourceBuilder
     * @return
     */
    private Object getEsList(SearchSourceBuilder searchSourceBuilder, String groupName) {
        try {
            SearchRequest searchRequest = new SearchRequest(Constants.ES_DATA_FOR_SUBJECT);
            searchSourceBuilder.trackTotalHits(true);
            searchRequest.source(searchSourceBuilder);
            SearchResponse search = client.search(searchRequest, RequestOptions.DEFAULT);
            return search.getAggregations().get(groupName);
        } catch (IOException e) {
            log.error("查询es专题资讯数据失败，e：{}", e);
        }
        return null;
    }

    private String getSubjectName(JSONArray records, String id) {
        Optional<Object> model = records.stream().filter(f -> ((Map) f).get("id").equals(id)).findFirst();
        if (model.isPresent())
            return ((Map) model.get()).get("subjectName").toString();
        else
            return "";
    }

    public List<Map<String, Object>> getPubliOpinionTrend(String queryBgDate, String queryEndate, Integer type) {
        String today = DateUtils.formatDate(DateUtils.getTimesMonthNight(), "yyyy-MM-dd");
        if (StringUtils.isBlank(queryBgDate)) {
            queryBgDate = today;
        }
        if (StringUtils.isBlank(queryEndate)) {
            queryEndate = today;
        }

        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = (BoolQueryBuilder) searchSourceBuilder.query();
        if (boolBuilder == null) {
            boolBuilder = QueryBuilders.boolQuery();
        }

        String timeFiled = "publishDate";
        boolBuilder.must(QueryBuilders.rangeQuery(timeFiled).gte(queryBgDate));
        boolBuilder.must(QueryBuilders.rangeQuery(timeFiled).lte(queryEndate));
        NestedQueryBuilder nestedQueryBuilder = null;
        if (type == 1)//正面
            nestedQueryBuilder = QueryBuilders
                    .nestedQuery("labels", QueryBuilders.termsQuery("labels.relationId", "1631119657360347137"), ScoreMode.None);
        else if (type == 2)//负面
            nestedQueryBuilder = QueryBuilders
                    .nestedQuery("labels", QueryBuilders.termsQuery("labels.relationId", "1631119691724279810"), ScoreMode.None);
        else
            return null;

        boolBuilder.must(nestedQueryBuilder);
        boolBuilder.must(QueryBuilders.termQuery("checkStatus", 1));// 0 未审核 1 审核 ？
        boolBuilder.must(QueryBuilders.termQuery("deleteFlag", 0));//未删除

        searchSourceBuilder.query(boolBuilder);
        DateHistogramAggregationBuilder aggregation = AggregationBuilders
                .dateHistogram("publishDate")
                .field("publishDate")
                .format("yyyy-MM-dd")
                .fixedInterval(DateHistogramInterval.DAY);
        searchSourceBuilder.aggregation(aggregation);
        List<Map<String, Object>> records = new ArrayList<>();
        Histogram byAgeAggregation = (Histogram) getEsList(searchSourceBuilder, "publishDate");
        for (Histogram.Bucket buck : byAgeAggregation.getBuckets()) {
            records.add(new HashMap<String, Object>() {
                {
                    put("date", buck.getKeyAsString());
                    put("num", buck.getDocCount());
                }
            });
        }
        return records;
    }
}
