package com.zzsn.clb.web.service;

import java.util.List;
import java.util.Map;

public interface ISubjectService {
    /***
     * 专题数据统计
     * @param type 本月-month 季度-quarter 本年-year
     * @param size 返回数据条数
     * @param subjectType 专题类型 通用-1 事件-2
     * @return
     */
    public List<Map<String,Object>> getSubjectCollect(String type,Integer size, Integer subjectType);


    /***
     * 专题趋势
     * @param queryBgDate 开始日期
     * @param queryEndate 结束日期
     * @return
     */
    List<Map<String, Object>> getDaySubjectTrend(String queryBgDate, String queryEndate);

    /***
     * 舆情走势
     * @param queryBgDate 开始日期
     * @param queryEndate 结束日期
     * @param type 1-正面 2-负面
     * @return
     */
    List<Map<String, Object>> getPubliOpinionTrend(String queryBgDate, String queryEndate, Integer type);


   }
