package com.zzsn.clb.member.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zzsn.clb.member.entity.MemRecommend;
import com.zzsn.clb.member.mapper.MemRecommendMapper;
import com.zzsn.clb.member.mapper.SubjectMapper;
import com.zzsn.clb.member.service.IMemRecommendService;
import com.zzsn.clb.member.service.ISubjectTreeService;
import com.zzsn.common.Constants;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.shiro.SecurityUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.jeecg.common.system.vo.LoginUser;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @Description: 会员-推荐资讯表
 * @Author: jeecg-boot
 * @Date: 2023-04-03
 * @Version: V1.0
 */
@Service
public class MemRecommendServiceImpl extends ServiceImpl<MemRecommendMapper, MemRecommend> implements IMemRecommendService {
    @Resource
    private RestHighLevelClient client;


    @Override
    public List<Map<String, Object>> getNewsList(Integer size, String keyWord, String labelId) {
        return getSubjectArticleList(1, size, keyWord, labelId);
    }

    @Override
    public void updateScoreBySubjectId(String subjectId, String userId, Integer score) {
        this.getBaseMapper().updateScoreBySubjectId(subjectId, userId, score);
    }


    /***
     * @param current
     * @param size
     * @param keyWord
     * @param labelId
     * @return
     */
    private List<Map<String, Object>> getSubjectArticleList(Integer current, Integer size, String keyWord, String labelId) {

        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = (BoolQueryBuilder) searchSourceBuilder.query();
        if (boolBuilder == null) {
            boolBuilder = QueryBuilders.boolQuery();
        }

        NestedQueryBuilder nestedQueryBuilder = null;
        //标签查询
        if (StringUtils.isNotBlank(labelId)) {
            nestedQueryBuilder = QueryBuilders
                    .nestedQuery("labels", QueryBuilders.termsQuery("labels.relationId", labelId), ScoreMode.None);
            boolBuilder.must(nestedQueryBuilder);
        }
        //关键词查询
        if (StringUtils.isNotBlank(keyWord)) {
            boolBuilder.must(QueryBuilders.matchPhraseQuery("content", keyWord));
        }


        boolBuilder.must(QueryBuilders.termQuery("checkStatus", 1));// 0 未审核 1 审核 ？
        boolBuilder.must(QueryBuilders.termQuery("deleteFlag", 0));//未删除
        //分页
        searchSourceBuilder.from((current - 1) * size).size(size);
        searchSourceBuilder.sort("publishDate", SortOrder.DESC);
        String[] includes = new String[]{"title", "publishDate", "subjectId", "id", "origin", "subjectName"};
        String[] excludes = Strings.EMPTY_ARRAY;
        searchSourceBuilder.fetchSource(includes, excludes);
        searchSourceBuilder.query(boolBuilder);
        return getSubjectArticleList(searchSourceBuilder);
    }

    /***
     * 执行专题信息查询操作
     * @param searchSourceBuilder
     * @return
     */
    private List<Map<String, Object>> getSubjectArticleList(SearchSourceBuilder searchSourceBuilder) {
        try {
            SearchRequest searchRequest = new SearchRequest(Constants.ES_DATA_FOR_SUBJECT);
            searchSourceBuilder.trackTotalHits(true);
            searchRequest.source(searchSourceBuilder);
            SearchResponse search = client.search(searchRequest, RequestOptions.DEFAULT);
            List<Map<String, Object>> records = new ArrayList<>();
            for (SearchHit documentFields : search.getHits().getHits()) {
                records.add(documentFields.getSourceAsMap());
            }
            return records;
        } catch (IOException e) {
            log.error("查询es专题资讯数据失败，e：{}", e);
        }
        return null;
    }
}
