package com.zzsn.clb.member.service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zzsn.clb.member.entity.MemRecommend;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;
import java.util.Map;

/**
 * @Description: 会员-推荐资讯表
 * @Author: jeecg-boot
 * @Date: 2023-04-03
 * @Version: V1.0
 */
public interface IMemRecommendService extends IService<MemRecommend> {

    /***
     * 获取推荐信息
     * @param size
     * @param keyWord
     * @param labelId
     * @return
     */
    List<Map<String, Object>> getNewsList(Integer size, String keyWord, String labelId);

    /***
     * 根据subjectId更新用户积分
     * @param subjectId
     * @param userId
     * @param score
     */
    void updateScoreBySubjectId(String subjectId, String userId, Integer score);
}
