package com.zzsn.clb.member.entity;

import java.io.Serializable;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * @Description: 会员-推荐资讯表
 * @Author: jeecg-boot
 * @Date:   2023-04-03
 * @Version: V1.0
 */
@Data
@TableName("mem_recommend")
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="mem_recommend对象", description="会员-推荐资讯表")
public class MemRecommend {
    
	/**id*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "id")
	private java.lang.String id;
	/**1 资讯 2 关键词*/
	@Excel(name = "1 资讯 2 关键词", width = 15)
    @ApiModelProperty(value = "0 专题 1 资讯 2 关键词")
	private java.lang.Integer type;
	/**分数*/
	@Excel(name = "分数", width = 15)
    @ApiModelProperty(value = "分数")
	private java.lang.Integer score;
	/**用户Id*/
	@Excel(name = "用户Id", width = 15)
    @ApiModelProperty(value = "用户Id")
	private java.lang.String userId;

	/**关键词*/
	@Excel(name = "关键词", width = 15)
	@ApiModelProperty(value = "关键词")
	private java.lang.String keyWord;

	/**专题Id*/
	@Excel(name = "专题Id", width = 15)
	@ApiModelProperty(value = "专题Id")
	private java.lang.String subjectId;
	/**标签id*/
	@Excel(name = "标签id", width = 15)
	@ApiModelProperty(value = "标签id")
	private java.lang.String labelId;
}
