package com.zzsn.clb.member.controller;

import java.util.*;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zzsn.clb.member.service.IMemRecommendAsynService;
import com.zzsn.clb.member.service.ISubjectTreeService;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.vo.LoginUser;
import com.zzsn.clb.member.entity.MemRecommend;
import com.zzsn.clb.member.service.IMemRecommendService;

import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.system.base.controller.JeecgController;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @Description: 会员-推荐资讯表
 * @Author: jeecg-boot
 * @Date: 2023-04-03
 * @Version: V1.0
 */
@Slf4j
@Api(tags = "会员-推荐资讯表")
@RestController
@RequestMapping("/mach/mem/recommend")
public class MemRecommendController extends JeecgController<MemRecommend, IMemRecommendService> {
    @Resource
    private IMemRecommendService memRecommendService;
    @Resource
    IMemRecommendAsynService memRecommendAsynService;

    /**
     * 分页列表查询
     *
     * @param memRecommend
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    @AutoLog(value = "会员-推荐资讯表-分页列表查询")
    @ApiOperation(value = "会员-推荐资讯表-分页列表查询", notes = "会员-推荐资讯表-分页列表查询")
    @GetMapping(value = "/list")
    public Result<?> queryPageList(MemRecommend memRecommend,
                                   @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                   @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                   HttpServletRequest req) {
        //获取推荐关键词，标签信息并积分排序
        LambdaQueryWrapper<MemRecommend> queryWrapper = new LambdaQueryWrapper<>();
        LoginUser user = (LoginUser) SecurityUtils.getSubject().getPrincipal();
        queryWrapper.eq(MemRecommend::getUserId, user.getId());
        queryWrapper.gt(MemRecommend::getScore, 0);
        queryWrapper.orderByDesc(MemRecommend::getScore);
        List<MemRecommend> list = memRecommendService.list(queryWrapper);

        List result = new ArrayList();
        //计算结束位置
        Integer endIndex = pageSize * pageNo;
        //根据关键词及标签装配资讯信息
        for (MemRecommend recommend : list) {
            Map<String, Object> map = new HashMap<>();
            Integer size = 3;
            String labelId = null;
            String keyWord = null;
            if (recommend.getType() == 2) {
                keyWord = recommend.getKeyWord();
                size = 5;
            } else {
                labelId = recommend.getLabelId();
            }
            List<Map<String, Object>> newsList = memRecommendService.getNewsList(size, keyWord, labelId);
            result.addAll(newsList);
            //超过100条退出
            if (result.size() >= 100)
                break;
        }
        if (result.size() == 0)
            return Result.OK(result);

        if (result.size() < endIndex)
            endIndex = result.size();
        Map<String, Object> map = new HashMap<>();
        int pages = (int) Math.ceil(result.size() * 10 * 0.1 / pageSize);
        pageNo = pageNo > pages ? pages : pageNo;
        map.put("current", pageNo);
        map.put("size", pageSize);
        map.put("total", result.size());
        map.put("pages", pages);
        map.put("records", result.subList(pageSize * (pageNo - 1), endIndex));

        return Result.OK(map);
    }


    /**
     * 添加
     *
     * @param memRecommend
     * @return
     */
    @AutoLog(value = "会员-推荐资讯表-添加")
    @ApiOperation(value = "会员-推荐资讯表-添加", notes = "会员-推荐资讯表-添加")
    @PostMapping(value = "/add")
    public Result<?> add(@RequestBody MemRecommend memRecommend) {
        boolean flag = true;
        LambdaQueryWrapper<MemRecommend> queryWrapper = new LambdaQueryWrapper<>();
        //栏目
        if (memRecommend.getType() == 0) {
            if (StringUtils.isBlank(memRecommend.getSubjectId()))
                return Result.error("专题Id不能为空！");
            memRecommend.setScore(1);
            memRecommend.setKeyWord(null);
            memRecommend.setLabelId(null);
            queryWrapper.eq(MemRecommend::getSubjectId, memRecommend.getSubjectId());
        } else if (memRecommend.getType() == 1) {//资讯信息
            if (StringUtils.isBlank(memRecommend.getSubjectId()))
                return Result.error("专题Id不能为空！");
            if (StringUtils.isBlank(memRecommend.getLabelId()))
                return Result.error("标签Id不能为空！");
            memRecommend.setScore(2);
            memRecommend.setKeyWord(null);
            queryWrapper.eq(MemRecommend::getSubjectId, memRecommend.getSubjectId());
            queryWrapper.eq(MemRecommend::getLabelId, memRecommend.getLabelId());
        } else if (memRecommend.getType() == 2) {//关键词
            if (StringUtils.isBlank(memRecommend.getKeyWord()))
                return Result.error("关键词不能为空！");
            memRecommend.setScore(5);
            memRecommend.setSubjectId(null);
            memRecommend.setLabelId(null);
            queryWrapper.eq(MemRecommend::getKeyWord, memRecommend.getKeyWord());
        } else {
            flag = false;
        }
        if (flag) {
            memRecommendAsynService.insert(memRecommend, queryWrapper);
        }
        return Result.OK("添加成功！");
    }
}
