package com.zzsn.utils;


import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExcelExportUtil {
    /**
     * 读取excel数据
     *
     * @param firstRow  第一行有用数据(0表示第一行)
     * @param columnNum 有用数据的总列数
     * @return java.util.List<java.util.List < java.lang.String>>
     */
    public static List<List<String>> readExcel(HttpServletRequest request, Integer firstRow, Integer columnNum) throws Exception {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        List<List<String>> dataList = new ArrayList<>();
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            MultipartFile file = entity.getValue();// 获取上传文件对象
            FileInputStream is = (FileInputStream) file.getInputStream();
            //获取整个excel
            XSSFWorkbook hb = new XSSFWorkbook(is);
            int sheets = hb.getNumberOfSheets();
            for (int i = 0; i < sheets; i++) {
                XSSFSheet sheet = hb.getSheetAt(i);
                //第一行
                int firstRowNum = sheet.getFirstRowNum();
                //最后一行
                int lastRowNum = sheet.getPhysicalNumberOfRows();
                for (int j = firstRowNum + firstRow; j < lastRowNum; j++) {
                    //获取行
                    XSSFRow row = sheet.getRow(j);
                    if (row != null) {
                        List<String> list = new ArrayList<>();
                        for (int m = 0; m < columnNum; m++) {
                            String data = ExcelExportUtil.getValue(row.getCell(m)).trim();
                            list.add(data);
                        }
                        dataList.add(list);
                    }
                }
            }
        }
        return dataList;
    }


    /**
     * 读取本地excel数据
     *
     * @param firstRow  第一行有用数据(0表示第一行)
     * @param columnNum 有用数据的总列数
     * @return java.util.List<java.util.List < java.lang.String>>
     */
    public static List<List<String>> readLocalExcel(String path, Integer firstRow, Integer columnNum) throws Exception {
        List<List<String>> dataList = new ArrayList<>();
        File file = new File(path);
        FileInputStream is = new FileInputStream(file.getAbsolutePath());
        //获取整个excel
        XSSFWorkbook hb = new XSSFWorkbook(is);
        int sheets = hb.getNumberOfSheets();
        for (int i = 0; i < sheets; i++) {
            XSSFSheet sheet = hb.getSheetAt(i);
            //第一行
            int firstRowNum = sheet.getFirstRowNum();
            //最后一行
            int lastRowNum = sheet.getPhysicalNumberOfRows();
            for (int j = firstRowNum + firstRow; j < lastRowNum; j++) {
                //获取行
                XSSFRow row = sheet.getRow(j);
                if (row != null) {
                    List<String> list = new ArrayList<>();
                    for (int m = 0; m < columnNum; m++) {
                        String data = ExcelExportUtil.getValue(row.getCell(m)).trim();
                        list.add(data);
                    }
                    dataList.add(list);
                }
            }
        }
        return dataList;
    }


    public static String getValue(XSSFCell xssfCell) {
        if (xssfCell == null || xssfCell.toString().trim().equals("")) {
            return "";
        }

        CellType cellType = xssfCell.getCellType();
     /*   if (cellType == CellType.NUMERIC) {
            return xssfCell.getStringCellValue();
        }*/
        if (cellType == CellType.NUMERIC) {
            if(HSSFDateUtil.isCellDateFormatted(xssfCell)){
                return TimeUtil.getDateString(xssfCell.getDateCellValue());
            }
            DecimalFormat df = new DecimalFormat("0");
            return df.format(xssfCell.getNumericCellValue());
        }

        return xssfCell.getStringCellValue();

    }

    /**
     * 获取标题栏样式
     *
     * @param workbook
     * @return
     */
    private static XSSFCellStyle getHeaderStyle(XSSFWorkbook workbook) {
        // 生成一个样式
        XSSFCellStyle style = workbook.createCellStyle();
        // 设置这些样式
        style.setFillForegroundColor(IndexedColors.SKY_BLUE.index);
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        // style.setDataFormat(HSSFDataFormat.getBuiltinFormat("0.00"));
        // 生成一个字体
        XSSFFont font = workbook.createFont();
        font.setColor(IndexedColors.BLACK.index);
        font.setFontHeightInPoints((short) 9);
        // 把字体应用到当前的样式
        style.setFont(font);
        return style;
    }

    /**
     * 获取字符串型内容栏样式
     *
     * @return
     */
    private static XSSFCellStyle getRowStrStyle(XSSFWorkbook workbook) {
        // 生成一个样式
        XSSFCellStyle style = workbook.createCellStyle();
        // 设置这些样式
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        // 生成一个字体
        XSSFFont font = workbook.createFont();
        font.setColor(IndexedColors.BLACK.index);
        font.setFontHeightInPoints((short) 9);
        font.setBold(true);
        // 把字体应用到当前的样式
        style.setFont(font);
        return style;
    }


    private static OutputStream getOutputStream(String fileName, HttpServletResponse response) throws Exception {
        fileName = URLEncoder.encode(fileName, "UTF-8");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf8");
        response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
        return response.getOutputStream();
    }

    public static List<List<String>> readExcel(String path) throws Exception {
        List<List<String>> dataList = new ArrayList<>();
        File file = new File(path);
        FileInputStream is = new FileInputStream(file.getAbsolutePath());
        //获取整个excel
        XSSFWorkbook hb = new XSSFWorkbook(is);
        //获取所有表单
        int sheets = hb.getNumberOfSheets();
        for (int m = 0; m < sheets; m++) {
            //获取表单
            XSSFSheet sheet = hb.getSheetAt(m);
            //第一行
            int firstRowNum = sheet.getFirstRowNum();
            //最后一行
            int lastRowNum = sheet.getPhysicalNumberOfRows();
            for (int j = firstRowNum + 1; j < 6; j++) {
                //获取行
                XSSFRow row = sheet.getRow(j);
                if (row != null) {
//                    short firstCellNum = row.getFirstCellNum();
//                    int lastCellNum = row.getPhysicalNumberOfCells();
                    List<String> list = new ArrayList<>();
                    for (int i = 1; i < 2; i++) {
                        String value = getValue(row.getCell(i));
                        list.add(value.trim());
                    }
                    dataList.add(list);
                }
            }
            break;
        }
        return dataList;
    }


    //多个sheet
    public static void exportExcelData(XSSFWorkbook workbook, int sheetNum, List<String> keyList, List<List<String>> rows, String sheetName) {
        Sheet sheet = workbook.createSheet();
        //多个sheet
        workbook.setSheetName(sheetNum, sheetName);
        sheet.setDefaultColumnWidth(20);
        sheet.setDefaultRowHeight((short) 400);
        XSSFCellStyle titleStyle = ExcelExportUtil.getHeaderStyle(workbook);
        XSSFCellStyle rowStrStyle = ExcelExportUtil.getRowStrStyle(workbook);
        // 产生表格标题行
        Row row = sheet.createRow(0);
        row.setHeight((short) 400);
        Cell cell;
        List<String> colData = new ArrayList<>(keyList);
        for (int i = 0; i < colData.size(); i++) {
            cell = row.createCell(i, CellType.STRING);
            cell.setCellStyle(titleStyle);
            cell.setCellValue(new XSSFRichTextString(colData.get(i)));
        }
        // 数据行
        for (int m = 0; m < rows.size(); m++) {
            List<String> rowData = rows.get(m);
            row = sheet.createRow(m + 1);
            row.setHeight((short) 400);
            int i = 0;
            for (String rowDatum : rowData) {
                createCell(rowStrStyle, row, i, rowDatum);
                i++;
            }
        }
    }

    private static void createCell(XSSFCellStyle rowStrStyle, Row row, int index, String value) {
        Cell cell = row.createCell(index, CellType.STRING);
        cell.setCellStyle(rowStrStyle);
        cell.setCellValue(value);
    }
}
