package com.zzsn.clb.test;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.zzsn.clb.member.mapper.SubjectMapper;
import com.zzsn.utils.ExcelExportUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.jeecg.common.api.vo.Result;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ImportParams;

import org.springframework.stereotype.Service;

import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.annotation.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * 系统用户单元测试
 */
@Service
@Slf4j
@DS("multi-clb-project")
public class ImportExcelData {

    @Resource
    private RestHighLevelClient client;

    @Resource
    SubjectMapper subjectMapper;

    public void importData() {
        String path = "C:\\Users\\EDY\\Documents\\WeChat Files\\wxid_7d7tl0zyfdxb21\\FileStorage\\File\\2023-02\\克虏宝汇总审核后数据.xlsx";
        try {
            impData(1, 10, path, 21);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected List<Map<String, Object>> importExcel(String path) {

        try {
            FileInputStream fileInputStream = new FileInputStream(path);
            ImportParams params = new ImportParams();
            params.setTitleRows(1);
            params.setHeadRows(1);
            params.setNeedSave(true);

            List<Map<String, Object>> list = ExcelImportUtil.importExcel(fileInputStream, Map.class, params);
            List<Map<String, Object>> subjectList = subjectMapper.getSubjectList();
            list.forEach(x -> {
                //setEsData(x, subjectList);
            });
            long start = System.currentTimeMillis();

            log.info("消耗时间" + (System.currentTimeMillis() - start) + "毫秒");
            Result var13 = Result.ok("文件导入成功！数据行数：" + list.size());
            return list;
        } catch (Exception var23) {
            log.error(var23.getMessage(), var23);

        } finally {

        }
        return null;
    }

    private List<List<String>> impData(Integer firstRow, Integer columnNum, String path, Integer rowLength) throws IOException {

        List<List<String>> dataList = new ArrayList<>();

        List<Map<String, Object>> subjectList = subjectMapper.getSubjectList();
        List<Map<String, Object>> negativeList = subjectMapper.getNegativeLabelList();

        FileInputStream is = new FileInputStream(path);// 获取上传文件对象
        // FileInputStream is = (FileInputStream) file.getInputStream();
        //获取整个excel
        XSSFWorkbook hb = new XSSFWorkbook(is);
        int sheets = hb.getNumberOfSheets();
        for (int i = 0; i < sheets; i++) {
            XSSFSheet sheet = hb.getSheetAt(i);
            //第一行
            int firstRowNum = sheet.getFirstRowNum();
            //最后一行
            int lastRowNum = rowLength;//sheet.getPhysicalNumberOfRows();
            for (int j = firstRowNum + firstRow; j < lastRowNum; j++) {
                //获取行
                XSSFRow row = sheet.getRow(j);
                if (row != null) {
                    List<String> list = new ArrayList<>();
                    for (int m = 0; m < columnNum; m++) {
                        String data = ExcelExportUtil.getValue(row.getCell(m)).trim();
                        list.add(data);
                    }
                    setEsData(list, subjectList,negativeList);
                    //dataList.add(list);
                }
            }
        }
        return dataList;
    }

    String subjectId = "";
    String labelId = null;
    String labelName = null;
    String labelMark = null;

    private void setEsData(List<String> list, List<Map<String, Object>> subjectList, List<Map<String, Object>> negativeList) throws IOException {

        SubjectData subjectData = new SubjectData();


        Integer score = 0;
        String title = null;
        String content = null;
        String author = null;
        String origin = null;
        String publishDate = null;
        if (StringUtils.isNotBlank(list.get(3))) {
            subjectData.setTitle(list.get(3));
        } else {
            return;
        }
        if (StringUtils.isNotBlank(list.get(0))) {
            String subjectName = list.get(0);
            if (!subjectName.equals("负面舆情")) {
                try {
                    subjectId = subjectList.stream().filter(f -> f.get("subjectName").equals(subjectName)).map(m -> m.get("subjectId")).findFirst().get().toString();
                } catch (Exception ex) {
                    log.error("错误：" + subjectName);
                    return;
                }
                labelName = list.get(1);
                //  Map<String, Object> map = subjectList.stream().filter(f -> f.get("labelName").equals(labelName) && f.get("subjectName").equals(subjectName)).findFirst().get();
                Map<String, Object> map = subjectList.stream().filter(f -> f.get("labelName").equals(labelName)).findFirst().get();
                labelId = map.get("labelId").toString();
                labelMark = map.get("labelMark").toString();
            } else {
                labelName = list.get(1);
                Map<String, Object> map = subjectList.stream().filter(f -> f.get("labelName").equals(labelName)).findFirst().get();
                labelId = map.get("labelId").toString();
                labelMark = map.get("labelMark").toString();
            }
        }
        subjectData.setSubjectId(subjectId);

        if (StringUtils.isNotBlank(list.get(4))) {
            subjectData.setSummary(list.get(4));
        }
        if (StringUtils.isNotBlank(list.get(5))) {
            subjectData.setContent(list.get(5));
        }
        if (StringUtils.isNotBlank(list.get(6))) {
            subjectData.setAuthor(list.get(6));
        }
        if (StringUtils.isNotBlank(list.get(7))) {
            subjectData.setOrigin(list.get(7));
        }
        if (StringUtils.isNotBlank(list.get(8))) {
            subjectData.setPublishDate(list.get(8));
        }

        if (StringUtils.isNotBlank(list.get(9))) {
            subjectData.setSourceAddress(list.get(9));
        }
        if (StringUtils.isNotBlank(subjectData.getTitle())) {
            List<Label> labelListlist = new ArrayList<>();
            String id = String.valueOf(IdWorker.getId());
            subjectData.setId(id);
            Label label = new Label();
            label.setRelationId(labelId);
            label.setRelationName(labelName);
            label.setLabelMark(labelMark);
            labelListlist.add(label);
            subjectData.setLabels(labelListlist);
            subjectData.setDeleteFlag(0);
            subjectData.setCheckStatus(1);
            log.info(JSON.toJSONString(subjectData));

            IndexRequest request = new IndexRequest("subjectdatabase")
                    .id(id)
                    .source(JSON.toJSONString(subjectData), XContentType.JSON);
            IndexResponse indexResponse = client.index(request, RequestOptions.DEFAULT);
            log.info(indexResponse.toString());
            //log.info("同步保存doc成功, _index=[{}], _id=[{}], _body=[{}]",index, id, jsonStr);
            // return indexResponse.getId();
        }

    }

}
