package com.zzsn.clb.member.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zzsn.clb.member.entity.MemCollect;
import com.zzsn.clb.member.mapper.MemCollectMapper;
import com.zzsn.clb.member.service.IMemCollectService;
import com.zzsn.clb.web.mapper.entity.SubjectDataExt;
import com.zzsn.clb.web.mapper.SubjectDataExtMapper;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * @Description: 会员收藏表
 * @Author: jeecg-boot
 * @Date: 2023-02-22
 * @Version: V1.0
 */
@Service
public class MemCollectServiceImpl extends ServiceImpl<MemCollectMapper, MemCollect> implements IMemCollectService {

    @Resource
    SubjectDataExtMapper subjectDataExtMapper;

    @Override
    @Transactional
    public void delete(LambdaQueryWrapper<MemCollect> queryWrapper, MemCollect memCollect) {
        this.baseMapper.delete(queryWrapper);
        subjectDataExtMapper.updateNum(memCollect.getArticleId(), "collect_num", -1);
    }

    @Override
    @Transactional
    public void add(MemCollect memCollect) {
        this.baseMapper.insert(memCollect);
        if (subjectDataExtMapper.selectById(memCollect.getArticleId()) == null) {
            SubjectDataExt subjectDataExt = new SubjectDataExt();
            subjectDataExt.setArticleId(memCollect.getArticleId());
            subjectDataExt.setThumbsUpNum(0);
            subjectDataExt.setCollectNum(0);
            subjectDataExtMapper.insert(subjectDataExt);
        }
        subjectDataExtMapper.updateNum(memCollect.getArticleId(), "collect_num", 1);
    }
}
