package com.zzsn.clb.web.controller;

import com.zzsn.clb.fegin.IServiceProjectClient;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @Description: 根据专题获取信息
 * @Author: jeecg-boot
 * @Date:   2023-02-17
 * @Version: V1.0
 */
@Slf4j
@Api(tags="对标分析菜单数据配置")
@RestController
@RequestMapping("/")
public class SubjectController {

    @Resource
    IServiceProjectClient serviceProjectClient;
    /**
     * 根据专题类型id查询数据
     * @param  id
     * @return
     */
    @AutoLog(value = "根据专题类型id查询数据")
    @ApiOperation(value="根据专题类型id查询数据", notes="根据专题类型id查询数据")
    @GetMapping(value = "/getListBySubjectType")
    public Result<?> getListBySubjectType(@RequestParam(required = true) String id)
    {
        return  serviceProjectClient.getListBySubjectType(id);
    }


    /**
     * 根据专题id查询数据
     * @param  id
     * @return
     */
    @AutoLog(value = "根据专题id查询数据")
    @ApiOperation(value="根据专题id查询数据", notes="根据专题id查询数据")
    @GetMapping(value = "/getListBySubject")
    public Result<?> getListBySubject(@RequestParam(required = true) String id)
    {
        return  serviceProjectClient.getListBySubject(id);
    }



    /**
     * 根据信息id查询数据
     * @param  id
     * @return
     */
    @AutoLog(value = "根据信息id查询数据")
    @ApiOperation(value="根据信息id查询数据", notes="根据信息id查询数据")
    @GetMapping(value = "/getSubjectById")
    public Result<?> getSubjectById(@RequestParam(required = true) String id)
    {
        return  serviceProjectClient.getSubjectById(id);
    }
}
